<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Goods Structs
 * @subpackage Structs
 */
class Goods extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupCode;
    /**
     * The UnitCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitCode;
    /**
     * The IsDuty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDuty;
    /**
     * The IsMostSales
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMostSales;
    /**
     * The IsEshop
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEshop;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Goods
     * @uses Goods::setGroupCode()
     * @uses Goods::setUnitCode()
     * @uses Goods::setIsDuty()
     * @uses Goods::setIsMostSales()
     * @uses Goods::setIsEshop()
     * @uses Goods::setCode()
     * @uses Goods::setName()
     * @uses Goods::setBarcode()
     * @uses Goods::setDescription()
     * @param int $groupCode
     * @param int $unitCode
     * @param bool $isDuty
     * @param bool $isMostSales
     * @param bool $isEshop
     * @param string $code
     * @param string $name
     * @param string $barcode
     * @param string $description
     */
    public function __construct($groupCode = null, $unitCode = null, $isDuty = null, $isMostSales = null, $isEshop = null, $code = null, $name = null, $barcode = null, $description = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setUnitCode($unitCode)
            ->setIsDuty($isDuty)
            ->setIsMostSales($isMostSales)
            ->setIsEshop($isEshop)
            ->setCode($code)
            ->setName($name)
            ->setBarcode($barcode)
            ->setDescription($description);
    }
    /**
     * Get GroupCode value
     * @return int
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param int $groupCode
     * @return \ServicePyramid\Structs\Goods
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: int
        if (!is_null($groupCode) && !is_numeric($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return int
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param int $unitCode
     * @return \ServicePyramid\Structs\Goods
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: int
        if (!is_null($unitCode) && !is_numeric($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get IsDuty value
     * @return bool
     */
    public function getIsDuty()
    {
        return $this->IsDuty;
    }
    /**
     * Set IsDuty value
     * @param bool $isDuty
     * @return \ServicePyramid\Structs\Goods
     */
    public function setIsDuty($isDuty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDuty) && !is_bool($isDuty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDuty)), __LINE__);
        }
        $this->IsDuty = $isDuty;
        return $this;
    }
    /**
     * Get IsMostSales value
     * @return bool
     */
    public function getIsMostSales()
    {
        return $this->IsMostSales;
    }
    /**
     * Set IsMostSales value
     * @param bool $isMostSales
     * @return \ServicePyramid\Structs\Goods
     */
    public function setIsMostSales($isMostSales = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMostSales) && !is_bool($isMostSales)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMostSales)), __LINE__);
        }
        $this->IsMostSales = $isMostSales;
        return $this;
    }
    /**
     * Get IsEshop value
     * @return bool
     */
    public function getIsEshop()
    {
        return $this->IsEshop;
    }
    /**
     * Set IsEshop value
     * @param bool $isEshop
     * @return \ServicePyramid\Structs\Goods
     */
    public function setIsEshop($isEshop = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEshop) && !is_bool($isEshop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEshop)), __LINE__);
        }
        $this->IsEshop = $isEshop;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \ServicePyramid\Structs\Goods
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \ServicePyramid\Structs\Goods
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \ServicePyramid\Structs\Goods
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \ServicePyramid\Structs\Goods
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\Goods
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
