<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodDescription Structs
 * @subpackage Structs
 */
class GoodDescription extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The GroupLabelId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupLabelId;
    /**
     * The GoodCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GoodCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for GoodDescription
     * @uses GoodDescription::setId()
     * @uses GoodDescription::setGroupLabelId()
     * @uses GoodDescription::setGoodCode()
     * @uses GoodDescription::setDescription()
     * @param int $id
     * @param int $groupLabelId
     * @param string $goodCode
     * @param string $description
     */
    public function __construct($id = null, $groupLabelId = null, $goodCode = null, $description = null)
    {
        $this
            ->setId($id)
            ->setGroupLabelId($groupLabelId)
            ->setGoodCode($goodCode)
            ->setDescription($description);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \ServicePyramid\Structs\GoodDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get GroupLabelId value
     * @return int
     */
    public function getGroupLabelId()
    {
        return $this->GroupLabelId;
    }
    /**
     * Set GroupLabelId value
     * @param int $groupLabelId
     * @return \ServicePyramid\Structs\GoodDescription
     */
    public function setGroupLabelId($groupLabelId = null)
    {
        // validation for constraint: int
        if (!is_null($groupLabelId) && !is_numeric($groupLabelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupLabelId)), __LINE__);
        }
        $this->GroupLabelId = $groupLabelId;
        return $this;
    }
    /**
     * Get GoodCode value
     * @return string|null
     */
    public function getGoodCode()
    {
        return $this->GoodCode;
    }
    /**
     * Set GoodCode value
     * @param string $goodCode
     * @return \ServicePyramid\Structs\GoodDescription
     */
    public function setGoodCode($goodCode = null)
    {
        // validation for constraint: string
        if (!is_null($goodCode) && !is_string($goodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goodCode)), __LINE__);
        }
        $this->GoodCode = $goodCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \ServicePyramid\Structs\GoodDescription
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\GoodDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
