<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMostSales Structs
 * @subpackage Structs
 */
class GetMostSales extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The mostSalesGoods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mostSalesGoods;
    /**
     * Constructor method for GetMostSales
     * @uses GetMostSales::setUsername()
     * @uses GetMostSales::setPassword()
     * @uses GetMostSales::setMostSalesGoods()
     * @param string $username
     * @param string $password
     * @param string $mostSalesGoods
     */
    public function __construct($username = null, $password = null, $mostSalesGoods = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setMostSalesGoods($mostSalesGoods);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \ServicePyramid\Structs\GetMostSales
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \ServicePyramid\Structs\GetMostSales
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get mostSalesGoods value
     * @return string|null
     */
    public function getMostSalesGoods()
    {
        return $this->mostSalesGoods;
    }
    /**
     * Set mostSalesGoods value
     * @param string $mostSalesGoods
     * @return \ServicePyramid\Structs\GetMostSales
     */
    public function setMostSalesGoods($mostSalesGoods = null)
    {
        // validation for constraint: string
        if (!is_null($mostSalesGoods) && !is_string($mostSalesGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mostSalesGoods)), __LINE__);
        }
        $this->mostSalesGoods = $mostSalesGoods;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\GetMostSales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
