<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryMethod Structs
 * @subpackage Structs
 */
class DeliveryMethod extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The ActionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ActionCode;
    /**
     * The Cost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Cost;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ImagePath
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImagePath;
    /**
     * Constructor method for DeliveryMethod
     * @uses DeliveryMethod::setId()
     * @uses DeliveryMethod::setType()
     * @uses DeliveryMethod::setActionCode()
     * @uses DeliveryMethod::setCost()
     * @uses DeliveryMethod::setIsActive()
     * @uses DeliveryMethod::setTitle()
     * @uses DeliveryMethod::setDescription()
     * @uses DeliveryMethod::setImagePath()
     * @param int $id
     * @param string $type
     * @param int $actionCode
     * @param float $cost
     * @param bool $isActive
     * @param string $title
     * @param string $description
     * @param string $imagePath
     */
    public function __construct($id = null, $type = null, $actionCode = null, $cost = null, $isActive = null, $title = null, $description = null, $imagePath = null)
    {
        $this
            ->setId($id)
            ->setType($type)
            ->setActionCode($actionCode)
            ->setCost($cost)
            ->setIsActive($isActive)
            ->setTitle($title)
            ->setDescription($description)
            ->setImagePath($imagePath);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \ServicePyramid\Enums\DeliveryMethodType::valueIsValid()
     * @uses \ServicePyramid\Enums\DeliveryMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\ServicePyramid\Enums\DeliveryMethodType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \ServicePyramid\Enums\DeliveryMethodType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return int
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param int $actionCode
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public function setActionCode($actionCode = null)
    {
        // validation for constraint: int
        if (!is_null($actionCode) && !is_numeric($actionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($actionCode)), __LINE__);
        }
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get Cost value
     * @return float
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param float $cost
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public function setCost($cost = null)
    {
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ImagePath value
     * @return string|null
     */
    public function getImagePath()
    {
        return $this->ImagePath;
    }
    /**
     * Set ImagePath value
     * @param string $imagePath
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public function setImagePath($imagePath = null)
    {
        // validation for constraint: string
        if (!is_null($imagePath) && !is_string($imagePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imagePath)), __LINE__);
        }
        $this->ImagePath = $imagePath;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\DeliveryMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
