<?php

namespace ServicePyramid\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sales Services
 * @subpackage Services
 */
class Sales extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetMostSales
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\GetMostSales $parameters
     * @return \ServicePyramid\Structs\GetMostSalesResponse|bool
     */
    public function GetMostSales(\ServicePyramid\Structs\GetMostSales $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMostSales($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ServicePyramid\Structs\GetMostSalesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
