<?php

namespace ServicePyramid\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Methods Services
 * @subpackage Services
 */
class Methods extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SyncDeliveryMethods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncDeliveryMethods $parameters
     * @return \ServicePyramid\Structs\SyncDeliveryMethodsResponse|bool
     */
    public function SyncDeliveryMethods(\ServicePyramid\Structs\SyncDeliveryMethods $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncDeliveryMethods($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SyncPaymentMethods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncPaymentMethods $parameters
     * @return \ServicePyramid\Structs\SyncPaymentMethodsResponse|bool
     */
    public function SyncPaymentMethods(\ServicePyramid\Structs\SyncPaymentMethods $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncPaymentMethods($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ServicePyramid\Structs\SyncDeliveryMethodsResponse|\ServicePyramid\Structs\SyncPaymentMethodsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
