<?php

namespace ServicePyramid\Enums;

/**
 * This class stands for BasketStatus Enums
 * @subpackage Enumerations
 */
class BasketStatus
{
    /**
     * Constant for value 'Register'
     * @return string 'Register'
     */
    const VALUE_REGISTER = 'Register';
    /**
     * Constant for value 'UnsuccessfullPay'
     * @return string 'UnsuccessfullPay'
     */
    const VALUE_UNSUCCESSFULL_PAY = 'UnsuccessfullPay';
    /**
     * Constant for value 'SuccessfullPay'
     * @return string 'SuccessfullPay'
     */
    const VALUE_SUCCESSFULL_PAY = 'SuccessfullPay';
    /**
     * Constant for value 'WaitingForPay'
     * @return string 'WaitingForPay'
     */
    const VALUE_WAITING_FOR_PAY = 'WaitingForPay';
    /**
     * Constant for value 'PyramidRegistered'
     * @return string 'PyramidRegistered'
     */
    const VALUE_PYRAMID_REGISTERED = 'PyramidRegistered';
    /**
     * Constant for value 'FinalConfirmation'
     * @return string 'FinalConfirmation'
     */
    const VALUE_FINAL_CONFIRMATION = 'FinalConfirmation';
    /**
     * Constant for value 'Sent'
     * @return string 'Sent'
     */
    const VALUE_SENT = 'Sent';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGISTER
     * @uses self::VALUE_UNSUCCESSFULL_PAY
     * @uses self::VALUE_SUCCESSFULL_PAY
     * @uses self::VALUE_WAITING_FOR_PAY
     * @uses self::VALUE_PYRAMID_REGISTERED
     * @uses self::VALUE_FINAL_CONFIRMATION
     * @uses self::VALUE_SENT
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_CANCELED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGISTER,
            self::VALUE_UNSUCCESSFULL_PAY,
            self::VALUE_SUCCESSFULL_PAY,
            self::VALUE_WAITING_FOR_PAY,
            self::VALUE_PYRAMID_REGISTERED,
            self::VALUE_FINAL_CONFIRMATION,
            self::VALUE_SENT,
            self::VALUE_COMPLETED,
            self::VALUE_CANCELED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
