<?php

namespace ServicePyramid;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'SyncGoodsData' => '\\ServicePyramid\\Structs\\SyncGoodsData',
            'ArrayOfSyncGoods' => '\\ServicePyramid\\Arrays\\ArrayOfSyncGoods',
            'SyncGoods' => '\\ServicePyramid\\Structs\\SyncGoods',
            'Goods' => '\\ServicePyramid\\Structs\\Goods',
            'SyncGoodsDataResponse' => '\\ServicePyramid\\Structs\\SyncGoodsDataResponse',
            'SyncGoodsWarehouseData' => '\\ServicePyramid\\Structs\\SyncGoodsWarehouseData',
            'ArrayOfSyncWarehouseProduct' => '\\ServicePyramid\\Arrays\\ArrayOfSyncWarehouseProduct',
            'SyncWarehouseProduct' => '\\ServicePyramid\\Structs\\SyncWarehouseProduct',
            'WarehouseProduct' => '\\ServicePyramid\\Structs\\WarehouseProduct',
            'SyncGoodsWarehouseDataResponse' => '\\ServicePyramid\\Structs\\SyncGoodsWarehouseDataResponse',
            'ArrayOfSyncResult' => '\\ServicePyramid\\Arrays\\ArrayOfSyncResult',
            'SyncResult' => '\\ServicePyramid\\Structs\\SyncResult',
            'SyncCustomerData' => '\\ServicePyramid\\Structs\\SyncCustomerData',
            'ArrayOfSyncCustomer' => '\\ServicePyramid\\Arrays\\ArrayOfSyncCustomer',
            'SyncCustomer' => '\\ServicePyramid\\Structs\\SyncCustomer',
            'Customer' => '\\ServicePyramid\\Structs\\Customer',
            'User' => '\\ServicePyramid\\Structs\\User',
            'SyncCustomerDataResponse' => '\\ServicePyramid\\Structs\\SyncCustomerDataResponse',
            'SyncGroupsData' => '\\ServicePyramid\\Structs\\SyncGroupsData',
            'ArrayOfSyncGroup' => '\\ServicePyramid\\Arrays\\ArrayOfSyncGroup',
            'SyncGroup' => '\\ServicePyramid\\Structs\\SyncGroup',
            'Group' => '\\ServicePyramid\\Structs\\Group',
            'SyncGroupsDataResponse' => '\\ServicePyramid\\Structs\\SyncGroupsDataResponse',
            'SyncGroupLabelsData' => '\\ServicePyramid\\Structs\\SyncGroupLabelsData',
            'ArrayOfSyncGroupLabels' => '\\ServicePyramid\\Arrays\\ArrayOfSyncGroupLabels',
            'SyncGroupLabels' => '\\ServicePyramid\\Structs\\SyncGroupLabels',
            'GroupLabels' => '\\ServicePyramid\\Structs\\GroupLabels',
            'SyncGroupLabelsDataResponse' => '\\ServicePyramid\\Structs\\SyncGroupLabelsDataResponse',
            'SyncGoodsDescription' => '\\ServicePyramid\\Structs\\SyncGoodsDescription',
            'ArrayOfSyncGoodsDescription' => '\\ServicePyramid\\Arrays\\ArrayOfSyncGoodsDescription',
            'GoodDescription' => '\\ServicePyramid\\Structs\\GoodDescription',
            'SyncGoodsDescriptionResponse' => '\\ServicePyramid\\Structs\\SyncGoodsDescriptionResponse',
            'SyncOrders' => '\\ServicePyramid\\Structs\\SyncOrders',
            'SyncOrdersResponse' => '\\ServicePyramid\\Structs\\SyncOrdersResponse',
            'ArrayOfBasket' => '\\ServicePyramid\\Arrays\\ArrayOfBasket',
            'Basket' => '\\ServicePyramid\\Structs\\Basket',
            'ArrayOfBasketDetail' => '\\ServicePyramid\\Arrays\\ArrayOfBasketDetail',
            'BasketDetail' => '\\ServicePyramid\\Structs\\BasketDetail',
            'DeliveryMethod' => '\\ServicePyramid\\Structs\\DeliveryMethod',
            'PaymentMethod' => '\\ServicePyramid\\Structs\\PaymentMethod',
            'SyncDeliveryMethods' => '\\ServicePyramid\\Structs\\SyncDeliveryMethods',
            'SyncDeliveryMethodsResponse' => '\\ServicePyramid\\Structs\\SyncDeliveryMethodsResponse',
            'ArrayOfDeliveryMethod' => '\\ServicePyramid\\Arrays\\ArrayOfDeliveryMethod',
            'SyncPaymentMethods' => '\\ServicePyramid\\Structs\\SyncPaymentMethods',
            'SyncPaymentMethodsResponse' => '\\ServicePyramid\\Structs\\SyncPaymentMethodsResponse',
            'ArrayOfPaymentMethod' => '\\ServicePyramid\\Arrays\\ArrayOfPaymentMethod',
            'ChangeOrderStatus' => '\\ServicePyramid\\Structs\\ChangeOrderStatus',
            'ArrayOfInt' => '\\ServicePyramid\\Arrays\\ArrayOfInt',
            'ChangeOrderStatusResponse' => '\\ServicePyramid\\Structs\\ChangeOrderStatusResponse',
            'WsTest' => '\\ServicePyramid\\Structs\\WsTest',
            'WsTestResponse' => '\\ServicePyramid\\Structs\\WsTestResponse',
            'GetMostSales' => '\\ServicePyramid\\Structs\\GetMostSales',
            'GetMostSalesResponse' => '\\ServicePyramid\\Structs\\GetMostSalesResponse',
        );
    }
}
