<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBasketDetail Arrays
 * @subpackage Arrays
 */
class ArrayOfBasketDetail extends AbstractStructArrayBase
{
    /**
     * The BasketDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\BasketDetail[]
     */
    public $BasketDetail;
    /**
     * Constructor method for ArrayOfBasketDetail
     * @uses ArrayOfBasketDetail::setBasketDetail()
     * @param \ServicePyramid\Structs\BasketDetail[] $basketDetail
     */
    public function __construct(array $basketDetail = array())
    {
        $this
            ->setBasketDetail($basketDetail);
    }
    /**
     * Get BasketDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\BasketDetail[]|null
     */
    public function getBasketDetail()
    {
        return isset($this->BasketDetail) ? $this->BasketDetail : null;
    }
    /**
     * Set BasketDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\BasketDetail[] $basketDetail
     * @return \ServicePyramid\Arrays\ArrayOfBasketDetail
     */
    public function setBasketDetail(array $basketDetail = array())
    {
        foreach ($basketDetail as $arrayOfBasketDetailBasketDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfBasketDetailBasketDetailItem instanceof \ServicePyramid\Structs\BasketDetail) {
                throw new \InvalidArgumentException(sprintf('The BasketDetail property can only contain items of \ServicePyramid\Structs\BasketDetail, "%s" given', is_object($arrayOfBasketDetailBasketDetailItem) ? get_class($arrayOfBasketDetailBasketDetailItem) : gettype($arrayOfBasketDetailBasketDetailItem)), __LINE__);
            }
        }
        if (is_null($basketDetail) || (is_array($basketDetail) && empty($basketDetail))) {
            unset($this->BasketDetail);
        } else {
            $this->BasketDetail = $basketDetail;
        }
        return $this;
    }
    /**
     * Add item to BasketDetail value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\BasketDetail $item
     * @return \ServicePyramid\Arrays\ArrayOfBasketDetail
     */
    public function addToBasketDetail(\ServicePyramid\Structs\BasketDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\BasketDetail) {
            throw new \InvalidArgumentException(sprintf('The BasketDetail property can only contain items of \ServicePyramid\Structs\BasketDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BasketDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\BasketDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\BasketDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\BasketDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\BasketDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\BasketDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BasketDetail
     */
    public function getAttributeName()
    {
        return 'BasketDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfBasketDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
