<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBasket Arrays
 * @subpackage Arrays
 */
class ArrayOfBasket extends AbstractStructArrayBase
{
    /**
     * The Basket
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\Basket[]
     */
    public $Basket;
    /**
     * Constructor method for ArrayOfBasket
     * @uses ArrayOfBasket::setBasket()
     * @param \ServicePyramid\Structs\Basket[] $basket
     */
    public function __construct(array $basket = array())
    {
        $this
            ->setBasket($basket);
    }
    /**
     * Get Basket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\Basket[]|null
     */
    public function getBasket()
    {
        return isset($this->Basket) ? $this->Basket : null;
    }
    /**
     * Set Basket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\Basket[] $basket
     * @return \ServicePyramid\Arrays\ArrayOfBasket
     */
    public function setBasket(array $basket = array())
    {
        foreach ($basket as $arrayOfBasketBasketItem) {
            // validation for constraint: itemType
            if (!$arrayOfBasketBasketItem instanceof \ServicePyramid\Structs\Basket) {
                throw new \InvalidArgumentException(sprintf('The Basket property can only contain items of \ServicePyramid\Structs\Basket, "%s" given', is_object($arrayOfBasketBasketItem) ? get_class($arrayOfBasketBasketItem) : gettype($arrayOfBasketBasketItem)), __LINE__);
            }
        }
        if (is_null($basket) || (is_array($basket) && empty($basket))) {
            unset($this->Basket);
        } else {
            $this->Basket = $basket;
        }
        return $this;
    }
    /**
     * Add item to Basket value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\Basket $item
     * @return \ServicePyramid\Arrays\ArrayOfBasket
     */
    public function addToBasket(\ServicePyramid\Structs\Basket $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\Basket) {
            throw new \InvalidArgumentException(sprintf('The Basket property can only contain items of \ServicePyramid\Structs\Basket, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Basket[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\Basket|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\Basket|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\Basket|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\Basket|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\Basket|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Basket
     */
    public function getAttributeName()
    {
        return 'Basket';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfBasket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
