<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://provisioningapi.microsoftonline.com/provisioningwebservice.svc?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://provisioningapi.microsoftonline.com/provisioningwebservice.svc?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetHeaderInfo operation/method
 */
if ($get->GetHeaderInfo(new \StructType\GetHeaderInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServiceStatus operation/method
 */
if ($get->GetServiceStatus(new \StructType\GetServiceStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPartnerInformation operation/method
 */
if ($get->GetPartnerInformation(new \StructType\GetPartnerInformation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdministrativeUnit operation/method
 */
if ($get->GetAdministrativeUnit(new \StructType\GetAdministrativeUnit()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyInformation operation/method
 */
if ($get->GetCompanyInformation(new \StructType\GetCompanyInformation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubscription operation/method
 */
if ($get->GetSubscription(new \StructType\GetSubscription()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccidentalDeletionInformation operation/method
 */
if ($get->GetAccidentalDeletionInformation(new \StructType\GetAccidentalDeletionInformation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyDirSyncFeatures operation/method
 */
if ($get->GetCompanyDirSyncFeatures(new \StructType\GetCompanyDirSyncFeatures()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPasswordPolicy operation/method
 */
if ($get->GetPasswordPolicy(new \StructType\GetPasswordPolicy()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyAllowedDataLocation operation/method
 */
if ($get->GetCompanyAllowedDataLocation(new \StructType\GetCompanyAllowedDataLocation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContact operation/method
 */
if ($get->GetContact(new \StructType\GetContact()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDomainFederationSettings operation/method
 */
if ($get->GetDomainFederationSettings(new \StructType\GetDomainFederationSettings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDomain operation/method
 */
if ($get->GetDomain(new \StructType\GetDomain()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDomainVerificationDns operation/method
 */
if ($get->GetDomainVerificationDns(new \StructType\GetDomainVerificationDns()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGroup operation/method
 */
if ($get->GetGroup(new \StructType\GetGroup()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRole operation/method
 */
if ($get->GetRole(new \StructType\GetRole()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRoleByName operation/method
 */
if ($get->GetRoleByName(new \StructType\GetRoleByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUser operation/method
 */
if ($get->GetUser(new \StructType\GetUser()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserByUpn operation/method
 */
if ($get->GetUserByUpn(new \StructType\GetUserByUpn()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserByLiveId operation/method
 */
if ($get->GetUserByLiveId(new \StructType\GetUserByLiveId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServicePrincipal operation/method
 */
if ($get->GetServicePrincipal(new \StructType\GetServicePrincipal()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServicePrincipalByAppPrincipalId operation/method
 */
if ($get->GetServicePrincipalByAppPrincipalId(new \StructType\GetServicePrincipalByAppPrincipalId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServicePrincipalBySpn operation/method
 */
if ($get->GetServicePrincipalBySpn(new \StructType\GetServicePrincipalBySpn()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Msol ServiceType
 */
$msol = new \ServiceType\Msol($options);
/**
 * Sample call for MsolConnect operation/method
 */
if ($msol->MsolConnect(new \StructType\MsolConnect()) !== false) {
    print_r($msol->getResult());
} else {
    print_r($msol->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddAdministrativeUnit operation/method
 */
if ($add->AddAdministrativeUnit(new \StructType\AddAdministrativeUnit()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAdministrativeUnitMembers operation/method
 */
if ($add->AddAdministrativeUnitMembers(new \StructType\AddAdministrativeUnitMembers()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDomain operation/method
 */
if ($add->AddDomain(new \StructType\AddDomain()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddGroup operation/method
 */
if ($add->AddGroup(new \StructType\AddGroup()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddWellKnownGroup operation/method
 */
if ($add->AddWellKnownGroup(new \StructType\AddWellKnownGroup()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddGroupMembers operation/method
 */
if ($add->AddGroupMembers(new \StructType\AddGroupMembers()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddRoleMembers operation/method
 */
if ($add->AddRoleMembers(new \StructType\AddRoleMembers()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddRoleMembersByRoleName operation/method
 */
if ($add->AddRoleMembersByRoleName(new \StructType\AddRoleMembersByRoleName()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddForeignGroupToRole operation/method
 */
if ($add->AddForeignGroupToRole(new \StructType\AddForeignGroupToRole()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddRoleScopedMembers operation/method
 */
if ($add->AddRoleScopedMembers(new \StructType\AddRoleScopedMembers()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUser operation/method
 */
if ($add->AddUser(new \StructType\AddUser()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddServicePrincipal operation/method
 */
if ($add->AddServicePrincipal(new \StructType\AddServicePrincipal()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddServicePrincipalCredentials operation/method
 */
if ($add->AddServicePrincipalCredentials(new \StructType\AddServicePrincipalCredentials()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddServicePrincipalCredentialsBySpn operation/method
 */
if ($add->AddServicePrincipalCredentialsBySpn(new \StructType\AddServicePrincipalCredentialsBySpn()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddServicePrincipalCredentialsByAppPrincipalId operation/method
 */
if ($add->AddServicePrincipalCredentialsByAppPrincipalId(new \StructType\AddServicePrincipalCredentialsByAppPrincipalId()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetAdministrativeUnit operation/method
 */
if ($set->SetAdministrativeUnit(new \StructType\SetAdministrativeUnit()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPartnerInformation operation/method
 */
if ($set->SetPartnerInformation(new \StructType\SetPartnerInformation()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanyContactInformation operation/method
 */
if ($set->SetCompanyContactInformation(new \StructType\SetCompanyContactInformation()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanySecurityComplianceContactInformation operation/method
 */
if ($set->SetCompanySecurityComplianceContactInformation(new \StructType\SetCompanySecurityComplianceContactInformation()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanyDirSyncEnabled operation/method
 */
if ($set->SetCompanyDirSyncEnabled(new \StructType\SetCompanyDirSyncEnabled()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAccidentalDeletionThreshold operation/method
 */
if ($set->SetAccidentalDeletionThreshold(new \StructType\SetAccidentalDeletionThreshold()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanyDirSyncFeature operation/method
 */
if ($set->SetCompanyDirSyncFeature(new \StructType\SetCompanyDirSyncFeature()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanyPasswordSyncEnabled operation/method
 */
if ($set->SetCompanyPasswordSyncEnabled(new \StructType\SetCompanyPasswordSyncEnabled()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanySettings operation/method
 */
if ($set->SetCompanySettings(new \StructType\SetCompanySettings()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPasswordPolicy operation/method
 */
if ($set->SetPasswordPolicy(new \StructType\SetPasswordPolicy()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanyMultiNationalEnabled operation/method
 */
if ($set->SetCompanyMultiNationalEnabled(new \StructType\SetCompanyMultiNationalEnabled()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanyAllowedDataLocation operation/method
 */
if ($set->SetCompanyAllowedDataLocation(new \StructType\SetCompanyAllowedDataLocation()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetDomain operation/method
 */
if ($set->SetDomain(new \StructType\SetDomain()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetDomainAuthentication operation/method
 */
if ($set->SetDomainAuthentication(new \StructType\SetDomainAuthentication()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetDomainFederationSettings operation/method
 */
if ($set->SetDomainFederationSettings(new \StructType\SetDomainFederationSettings()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetGroup operation/method
 */
if ($set->SetGroup(new \StructType\SetGroup()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUser operation/method
 */
if ($set->SetUser(new \StructType\SetUser()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUserLicenses operation/method
 */
if ($set->SetUserLicenses(new \StructType\SetUserLicenses()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUserLicensesByUpn operation/method
 */
if ($set->SetUserLicensesByUpn(new \StructType\SetUserLicensesByUpn()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetServicePrincipal operation/method
 */
if ($set->SetServicePrincipal(new \StructType\SetServicePrincipal()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for RemoveAdministrativeUnit operation/method
 */
if ($remove->RemoveAdministrativeUnit(new \StructType\RemoveAdministrativeUnit()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveAdministrativeUnitMembers operation/method
 */
if ($remove->RemoveAdministrativeUnitMembers(new \StructType\RemoveAdministrativeUnitMembers()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveContact operation/method
 */
if ($remove->RemoveContact(new \StructType\RemoveContact()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveDomain operation/method
 */
if ($remove->RemoveDomain(new \StructType\RemoveDomain()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveGroup operation/method
 */
if ($remove->RemoveGroup(new \StructType\RemoveGroup()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveGroupMembers operation/method
 */
if ($remove->RemoveGroupMembers(new \StructType\RemoveGroupMembers()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveRoleMembers operation/method
 */
if ($remove->RemoveRoleMembers(new \StructType\RemoveRoleMembers()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveRoleMembersByRoleName operation/method
 */
if ($remove->RemoveRoleMembersByRoleName(new \StructType\RemoveRoleMembersByRoleName()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveForeignGroupFromRole operation/method
 */
if ($remove->RemoveForeignGroupFromRole(new \StructType\RemoveForeignGroupFromRole()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveRoleScopedMembers operation/method
 */
if ($remove->RemoveRoleScopedMembers(new \StructType\RemoveRoleScopedMembers()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveUser operation/method
 */
if ($remove->RemoveUser(new \StructType\RemoveUser()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveUserByUpn operation/method
 */
if ($remove->RemoveUserByUpn(new \StructType\RemoveUserByUpn()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveServicePrincipal operation/method
 */
if ($remove->RemoveServicePrincipal(new \StructType\RemoveServicePrincipal()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveServicePrincipalByAppPrincipalId operation/method
 */
if ($remove->RemoveServicePrincipalByAppPrincipalId(new \StructType\RemoveServicePrincipalByAppPrincipalId()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveServicePrincipalBySpn operation/method
 */
if ($remove->RemoveServicePrincipalBySpn(new \StructType\RemoveServicePrincipalBySpn()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveServicePrincipalCredentials operation/method
 */
if ($remove->RemoveServicePrincipalCredentials(new \StructType\RemoveServicePrincipalCredentials()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveServicePrincipalCredentialsBySpn operation/method
 */
if ($remove->RemoveServicePrincipalCredentialsBySpn(new \StructType\RemoveServicePrincipalCredentialsBySpn()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveServicePrincipalCredentialsByAppPrincipalId
 * operation/method
 */
if ($remove->RemoveServicePrincipalCredentialsByAppPrincipalId(new \StructType\RemoveServicePrincipalCredentialsByAppPrincipalId()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for ListAdministrativeUnits operation/method
 */
if ($list->ListAdministrativeUnits(new \StructType\ListAdministrativeUnits()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAdministrativeUnitMembers operation/method
 */
if ($list->ListAdministrativeUnitMembers(new \StructType\ListAdministrativeUnitMembers()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListSubscriptions operation/method
 */
if ($list->ListSubscriptions(new \StructType\ListSubscriptions()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListAccountSkus operation/method
 */
if ($list->ListAccountSkus(new \StructType\ListAccountSkus()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListPartnerContracts operation/method
 */
if ($list->ListPartnerContracts(new \StructType\ListPartnerContracts()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListDirSyncProvisioningErrors operation/method
 */
if ($list->ListDirSyncProvisioningErrors(new \StructType\ListDirSyncProvisioningErrors()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListContacts operation/method
 */
if ($list->ListContacts(new \StructType\ListContacts()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListDomains operation/method
 */
if ($list->ListDomains(new \StructType\ListDomains()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListGroups operation/method
 */
if ($list->ListGroups(new \StructType\ListGroups()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListGroupMembers operation/method
 */
if ($list->ListGroupMembers(new \StructType\ListGroupMembers()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListRoles operation/method
 */
if ($list->ListRoles(new \StructType\ListRoles()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListRolesForUser operation/method
 */
if ($list->ListRolesForUser(new \StructType\ListRolesForUser()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListRolesForUserByUpn operation/method
 */
if ($list->ListRolesForUserByUpn(new \StructType\ListRolesForUserByUpn()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListRoleMembers operation/method
 */
if ($list->ListRoleMembers(new \StructType\ListRoleMembers()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListRoleScopedMembers operation/method
 */
if ($list->ListRoleScopedMembers(new \StructType\ListRoleScopedMembers()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListUsers operation/method
 */
if ($list->ListUsers(new \StructType\ListUsers()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListUsersByStrongAuthentication operation/method
 */
if ($list->ListUsersByStrongAuthentication(new \StructType\ListUsersByStrongAuthentication()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListServicePrincipals operation/method
 */
if ($list->ListServicePrincipals(new \StructType\ListServicePrincipals()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListServicePrincipalCredentials operation/method
 */
if ($list->ListServicePrincipalCredentials(new \StructType\ListServicePrincipalCredentials()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListServicePrincipalCredentialsByAppPrincipalId operation/method
 */
if ($list->ListServicePrincipalCredentialsByAppPrincipalId(new \StructType\ListServicePrincipalCredentialsByAppPrincipalId()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListServicePrincipalCredentialsBySpn operation/method
 */
if ($list->ListServicePrincipalCredentialsBySpn(new \StructType\ListServicePrincipalCredentialsBySpn()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Navigate ServiceType
 */
$navigate = new \ServiceType\Navigate($options);
/**
 * Sample call for NavigateAdministrativeUnitResults operation/method
 */
if ($navigate->NavigateAdministrativeUnitResults(new \StructType\NavigateAdministrativeUnitResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateAdministrativeUnitMemberResults operation/method
 */
if ($navigate->NavigateAdministrativeUnitMemberResults(new \StructType\NavigateAdministrativeUnitMemberResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigatePartnerContracts operation/method
 */
if ($navigate->NavigatePartnerContracts(new \StructType\NavigatePartnerContracts()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateDirSyncProvisioningErrors operation/method
 */
if ($navigate->NavigateDirSyncProvisioningErrors(new \StructType\NavigateDirSyncProvisioningErrors()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateContactResults operation/method
 */
if ($navigate->NavigateContactResults(new \StructType\NavigateContactResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateGroupResults operation/method
 */
if ($navigate->NavigateGroupResults(new \StructType\NavigateGroupResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateGroupMemberResults operation/method
 */
if ($navigate->NavigateGroupMemberResults(new \StructType\NavigateGroupMemberResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateRoleMemberResults operation/method
 */
if ($navigate->NavigateRoleMemberResults(new \StructType\NavigateRoleMemberResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateRoleScopedMemberResults operation/method
 */
if ($navigate->NavigateRoleScopedMemberResults(new \StructType\NavigateRoleScopedMemberResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateUserResults operation/method
 */
if ($navigate->NavigateUserResults(new \StructType\NavigateUserResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Sample call for NavigateServicePrincipalResults operation/method
 */
if ($navigate->NavigateServicePrincipalResults(new \StructType\NavigateServicePrincipalResults()) !== false) {
    print_r($navigate->getResult());
} else {
    print_r($navigate->getLastError());
}
/**
 * Samples for Has ServiceType
 */
$has = new \ServiceType\Has($options);
/**
 * Sample call for HasObjectsWithDirSyncProvisioningErrors operation/method
 */
if ($has->HasObjectsWithDirSyncProvisioningErrors(new \StructType\HasObjectsWithDirSyncProvisioningErrors()) !== false) {
    print_r($has->getResult());
} else {
    print_r($has->getLastError());
}
/**
 * Sample call for HasObjectsWithDirSyncProvisioningErrors2 operation/method
 */
if ($has->HasObjectsWithDirSyncProvisioningErrors2(new \StructType\HasObjectsWithDirSyncProvisioningErrors2()) !== false) {
    print_r($has->getResult());
} else {
    print_r($has->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateDirSyncProvisioningError operation/method
 */
if ($update->UpdateDirSyncProvisioningError(new \StructType\UpdateDirSyncProvisioningError()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Retry ServiceType
 */
$retry = new \ServiceType\Retry($options);
/**
 * Sample call for RetryContactProvisioning operation/method
 */
if ($retry->RetryContactProvisioning(new \StructType\RetryContactProvisioning()) !== false) {
    print_r($retry->getResult());
} else {
    print_r($retry->getLastError());
}
/**
 * Sample call for RetryGroupProvisioning operation/method
 */
if ($retry->RetryGroupProvisioning(new \StructType\RetryGroupProvisioning()) !== false) {
    print_r($retry->getResult());
} else {
    print_r($retry->getLastError());
}
/**
 * Sample call for RetryUserProvisioning operation/method
 */
if ($retry->RetryUserProvisioning(new \StructType\RetryUserProvisioning()) !== false) {
    print_r($retry->getResult());
} else {
    print_r($retry->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \ServiceType\Verify($options);
/**
 * Sample call for VerifyDomain operation/method
 */
if ($verify->VerifyDomain(new \StructType\VerifyDomain()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyDomain2 operation/method
 */
if ($verify->VerifyDomain2(new \StructType\VerifyDomain2()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyEmailVerifiedDomain operation/method
 */
if ($verify->VerifyEmailVerifiedDomain(new \StructType\VerifyEmailVerifiedDomain()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for ChangeUserPrincipalName operation/method
 */
if ($change->ChangeUserPrincipalName(new \StructType\ChangeUserPrincipalName()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeUserPrincipalNameByUpn operation/method
 */
if ($change->ChangeUserPrincipalNameByUpn(new \StructType\ChangeUserPrincipalNameByUpn()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
/**
 * Sample call for ResetUserPassword operation/method
 */
if ($reset->ResetUserPassword(new \StructType\ResetUserPassword()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Sample call for ResetUserPasswordByUpn operation/method
 */
if ($reset->ResetUserPasswordByUpn(new \StructType\ResetUserPasswordByUpn()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Sample call for ResetStrongAuthenticationMethodByUpn operation/method
 */
if ($reset->ResetStrongAuthenticationMethodByUpn(new \StructType\ResetStrongAuthenticationMethodByUpn()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \ServiceType\Convert($options);
/**
 * Sample call for ConvertFederatedUserToManaged operation/method
 */
if ($convert->ConvertFederatedUserToManaged(new \StructType\ConvertFederatedUserToManaged()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Samples for Restore ServiceType
 */
$restore = new \ServiceType\Restore($options);
/**
 * Sample call for RestoreUser operation/method
 */
if ($restore->RestoreUser(new \StructType\RestoreUser()) !== false) {
    print_r($restore->getResult());
} else {
    print_r($restore->getLastError());
}
/**
 * Sample call for RestoreUserByUpn operation/method
 */
if ($restore->RestoreUserByUpn(new \StructType\RestoreUserByUpn()) !== false) {
    print_r($restore->getResult());
} else {
    print_r($restore->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteApplicationPassword operation/method
 */
if ($delete->DeleteApplicationPassword(new \StructType\DeleteApplicationPassword()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
