<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifyDomainRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:VerifyDomainRequest
 * @subpackage Structs
 */
class VerifyDomainRequest extends Request
{
    /**
     * The DomainName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainName;
    /**
     * The FederationSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DomainFederationSettings
     */
    public $FederationSettings;
    /**
     * The ForceTakeover
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ForceTakeover;
    /**
     * Constructor method for VerifyDomainRequest
     * @uses VerifyDomainRequest::setDomainName()
     * @uses VerifyDomainRequest::setFederationSettings()
     * @uses VerifyDomainRequest::setForceTakeover()
     * @param string $domainName
     * @param \StructType\DomainFederationSettings $federationSettings
     * @param string $forceTakeover
     */
    public function __construct($domainName = null, \StructType\DomainFederationSettings $federationSettings = null, $forceTakeover = null)
    {
        $this
            ->setDomainName($domainName)
            ->setFederationSettings($federationSettings)
            ->setForceTakeover($forceTakeover);
    }
    /**
     * Get DomainName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->DomainName) ? $this->DomainName : null;
    }
    /**
     * Set DomainName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainName
     * @return \StructType\VerifyDomainRequest
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->DomainName);
        } else {
            $this->DomainName = $domainName;
        }
        return $this;
    }
    /**
     * Get FederationSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DomainFederationSettings|null
     */
    public function getFederationSettings()
    {
        return isset($this->FederationSettings) ? $this->FederationSettings : null;
    }
    /**
     * Set FederationSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DomainFederationSettings $federationSettings
     * @return \StructType\VerifyDomainRequest
     */
    public function setFederationSettings(\StructType\DomainFederationSettings $federationSettings = null)
    {
        if (is_null($federationSettings) || (is_array($federationSettings) && empty($federationSettings))) {
            unset($this->FederationSettings);
        } else {
            $this->FederationSettings = $federationSettings;
        }
        return $this;
    }
    /**
     * Get ForceTakeover value
     * @return string|null
     */
    public function getForceTakeover()
    {
        return $this->ForceTakeover;
    }
    /**
     * Set ForceTakeover value
     * @uses \EnumType\ForceTakeoverOption::valueIsValid()
     * @uses \EnumType\ForceTakeoverOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $forceTakeover
     * @return \StructType\VerifyDomainRequest
     */
    public function setForceTakeover($forceTakeover = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ForceTakeoverOption::valueIsValid($forceTakeover)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $forceTakeover, implode(', ', \EnumType\ForceTakeoverOption::getValidValues())), __LINE__);
        }
        $this->ForceTakeover = $forceTakeover;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerifyDomainRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
