<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationError StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidationError
 * @subpackage Structs
 */
class ValidationError extends AbstractStructBase
{
    /**
     * The ErrorDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorDetail
     */
    public $ErrorDetail;
    /**
     * The Resolved
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Resolved;
    /**
     * The ServiceInstance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceInstance;
    /**
     * The Timestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Timestamp;
    /**
     * Constructor method for ValidationError
     * @uses ValidationError::setErrorDetail()
     * @uses ValidationError::setResolved()
     * @uses ValidationError::setServiceInstance()
     * @uses ValidationError::setTimestamp()
     * @param \StructType\ErrorDetail $errorDetail
     * @param bool $resolved
     * @param string $serviceInstance
     * @param string $timestamp
     */
    public function __construct(\StructType\ErrorDetail $errorDetail = null, $resolved = null, $serviceInstance = null, $timestamp = null)
    {
        $this
            ->setErrorDetail($errorDetail)
            ->setResolved($resolved)
            ->setServiceInstance($serviceInstance)
            ->setTimestamp($timestamp);
    }
    /**
     * Get ErrorDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorDetail|null
     */
    public function getErrorDetail()
    {
        return isset($this->ErrorDetail) ? $this->ErrorDetail : null;
    }
    /**
     * Set ErrorDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ErrorDetail $errorDetail
     * @return \StructType\ValidationError
     */
    public function setErrorDetail(\StructType\ErrorDetail $errorDetail = null)
    {
        if (is_null($errorDetail) || (is_array($errorDetail) && empty($errorDetail))) {
            unset($this->ErrorDetail);
        } else {
            $this->ErrorDetail = $errorDetail;
        }
        return $this;
    }
    /**
     * Get Resolved value
     * @return bool|null
     */
    public function getResolved()
    {
        return $this->Resolved;
    }
    /**
     * Set Resolved value
     * @param bool $resolved
     * @return \StructType\ValidationError
     */
    public function setResolved($resolved = null)
    {
        $this->Resolved = $resolved;
        return $this;
    }
    /**
     * Get ServiceInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceInstance()
    {
        return isset($this->ServiceInstance) ? $this->ServiceInstance : null;
    }
    /**
     * Set ServiceInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceInstance
     * @return \StructType\ValidationError
     */
    public function setServiceInstance($serviceInstance = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInstance) && !is_string($serviceInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceInstance)), __LINE__);
        }
        if (is_null($serviceInstance) || (is_array($serviceInstance) && empty($serviceInstance))) {
            unset($this->ServiceInstance);
        } else {
            $this->ServiceInstance = $serviceInstance;
        }
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\ValidationError
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidationError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
