<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserSearchByStrongAuthenticationDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UserSearchByStrongAuthenticationDefinition
 * @subpackage Structs
 */
class UserSearchByStrongAuthenticationDefinition extends SearchDefinition
{
    /**
     * The IncludedProperties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $IncludedProperties;
    /**
     * The RequirementUnsetOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RequirementUnsetOnly;
    /**
     * The Requirements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStrongAuthenticationRequirement
     */
    public $Requirements;
    /**
     * The RoleObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleObjectId;
    /**
     * Constructor method for UserSearchByStrongAuthenticationDefinition
     * @uses UserSearchByStrongAuthenticationDefinition::setIncludedProperties()
     * @uses UserSearchByStrongAuthenticationDefinition::setRequirementUnsetOnly()
     * @uses UserSearchByStrongAuthenticationDefinition::setRequirements()
     * @uses UserSearchByStrongAuthenticationDefinition::setRoleObjectId()
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @param bool $requirementUnsetOnly
     * @param \ArrayType\ArrayOfStrongAuthenticationRequirement $requirements
     * @param string $roleObjectId
     */
    public function __construct(\ArrayType\ArrayOfstring $includedProperties = null, $requirementUnsetOnly = null, \ArrayType\ArrayOfStrongAuthenticationRequirement $requirements = null, $roleObjectId = null)
    {
        $this
            ->setIncludedProperties($includedProperties)
            ->setRequirementUnsetOnly($requirementUnsetOnly)
            ->setRequirements($requirements)
            ->setRoleObjectId($roleObjectId);
    }
    /**
     * Get IncludedProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getIncludedProperties()
    {
        return isset($this->IncludedProperties) ? $this->IncludedProperties : null;
    }
    /**
     * Set IncludedProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @return \StructType\UserSearchByStrongAuthenticationDefinition
     */
    public function setIncludedProperties(\ArrayType\ArrayOfstring $includedProperties = null)
    {
        if (is_null($includedProperties) || (is_array($includedProperties) && empty($includedProperties))) {
            unset($this->IncludedProperties);
        } else {
            $this->IncludedProperties = $includedProperties;
        }
        return $this;
    }
    /**
     * Get RequirementUnsetOnly value
     * @return bool|null
     */
    public function getRequirementUnsetOnly()
    {
        return $this->RequirementUnsetOnly;
    }
    /**
     * Set RequirementUnsetOnly value
     * @param bool $requirementUnsetOnly
     * @return \StructType\UserSearchByStrongAuthenticationDefinition
     */
    public function setRequirementUnsetOnly($requirementUnsetOnly = null)
    {
        $this->RequirementUnsetOnly = $requirementUnsetOnly;
        return $this;
    }
    /**
     * Get Requirements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStrongAuthenticationRequirement|null
     */
    public function getRequirements()
    {
        return isset($this->Requirements) ? $this->Requirements : null;
    }
    /**
     * Set Requirements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStrongAuthenticationRequirement $requirements
     * @return \StructType\UserSearchByStrongAuthenticationDefinition
     */
    public function setRequirements(\ArrayType\ArrayOfStrongAuthenticationRequirement $requirements = null)
    {
        if (is_null($requirements) || (is_array($requirements) && empty($requirements))) {
            unset($this->Requirements);
        } else {
            $this->Requirements = $requirements;
        }
        return $this;
    }
    /**
     * Get RoleObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleObjectId()
    {
        return isset($this->RoleObjectId) ? $this->RoleObjectId : null;
    }
    /**
     * Set RoleObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roleObjectId
     * @return \StructType\UserSearchByStrongAuthenticationDefinition
     */
    public function setRoleObjectId($roleObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($roleObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $roleObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($roleObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roleObjectId) && !is_string($roleObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleObjectId)), __LINE__);
        }
        if (is_null($roleObjectId) || (is_array($roleObjectId) && empty($roleObjectId))) {
            unset($this->RoleObjectId);
        } else {
            $this->RoleObjectId = $roleObjectId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserSearchByStrongAuthenticationDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
