<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserLicense StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UserLicense
 * @subpackage Structs
 */
class UserLicense extends AbstractStructBase
{
    /**
     * The AccountSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountSkuIdentifier
     */
    public $AccountSku;
    /**
     * The AccountSkuId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountSkuId;
    /**
     * The GroupsAssigningLicense
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfguid
     */
    public $GroupsAssigningLicense;
    /**
     * The ServiceStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceStatus
     */
    public $ServiceStatus;
    /**
     * Constructor method for UserLicense
     * @uses UserLicense::setAccountSku()
     * @uses UserLicense::setAccountSkuId()
     * @uses UserLicense::setGroupsAssigningLicense()
     * @uses UserLicense::setServiceStatus()
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @param string $accountSkuId
     * @param \ArrayType\ArrayOfguid $groupsAssigningLicense
     * @param \ArrayType\ArrayOfServiceStatus $serviceStatus
     */
    public function __construct(\StructType\AccountSkuIdentifier $accountSku = null, $accountSkuId = null, \ArrayType\ArrayOfguid $groupsAssigningLicense = null, \ArrayType\ArrayOfServiceStatus $serviceStatus = null)
    {
        $this
            ->setAccountSku($accountSku)
            ->setAccountSkuId($accountSkuId)
            ->setGroupsAssigningLicense($groupsAssigningLicense)
            ->setServiceStatus($serviceStatus);
    }
    /**
     * Get AccountSku value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountSkuIdentifier|null
     */
    public function getAccountSku()
    {
        return isset($this->AccountSku) ? $this->AccountSku : null;
    }
    /**
     * Set AccountSku value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @return \StructType\UserLicense
     */
    public function setAccountSku(\StructType\AccountSkuIdentifier $accountSku = null)
    {
        if (is_null($accountSku) || (is_array($accountSku) && empty($accountSku))) {
            unset($this->AccountSku);
        } else {
            $this->AccountSku = $accountSku;
        }
        return $this;
    }
    /**
     * Get AccountSkuId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountSkuId()
    {
        return isset($this->AccountSkuId) ? $this->AccountSkuId : null;
    }
    /**
     * Set AccountSkuId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountSkuId
     * @return \StructType\UserLicense
     */
    public function setAccountSkuId($accountSkuId = null)
    {
        // validation for constraint: string
        if (!is_null($accountSkuId) && !is_string($accountSkuId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountSkuId)), __LINE__);
        }
        if (is_null($accountSkuId) || (is_array($accountSkuId) && empty($accountSkuId))) {
            unset($this->AccountSkuId);
        } else {
            $this->AccountSkuId = $accountSkuId;
        }
        return $this;
    }
    /**
     * Get GroupsAssigningLicense value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfguid|null
     */
    public function getGroupsAssigningLicense()
    {
        return isset($this->GroupsAssigningLicense) ? $this->GroupsAssigningLicense : null;
    }
    /**
     * Set GroupsAssigningLicense value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfguid $groupsAssigningLicense
     * @return \StructType\UserLicense
     */
    public function setGroupsAssigningLicense(\ArrayType\ArrayOfguid $groupsAssigningLicense = null)
    {
        if (is_null($groupsAssigningLicense) || (is_array($groupsAssigningLicense) && empty($groupsAssigningLicense))) {
            unset($this->GroupsAssigningLicense);
        } else {
            $this->GroupsAssigningLicense = $groupsAssigningLicense;
        }
        return $this;
    }
    /**
     * Get ServiceStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServiceStatus|null
     */
    public function getServiceStatus()
    {
        return isset($this->ServiceStatus) ? $this->ServiceStatus : null;
    }
    /**
     * Set ServiceStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServiceStatus $serviceStatus
     * @return \StructType\UserLicense
     */
    public function setServiceStatus(\ArrayType\ArrayOfServiceStatus $serviceStatus = null)
    {
        if (is_null($serviceStatus) || (is_array($serviceStatus) && empty($serviceStatus))) {
            unset($this->ServiceStatus);
        } else {
            $this->ServiceStatus = $serviceStatus;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserLicense
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
