<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Subscription
 * @subpackage Structs
 */
class Subscription extends AbstractStructBase
{
    /**
     * The DateCreated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateCreated;
    /**
     * The IsTrial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTrial;
    /**
     * The NextLifecycleDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextLifecycleDate;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The OcpSubscriptionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OcpSubscriptionId;
    /**
     * The OwnerContextId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerContextId;
    /**
     * The OwnerObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerObjectId;
    /**
     * The OwnerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerType;
    /**
     * The ServiceStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceStatus
     */
    public $ServiceStatus;
    /**
     * The SkuId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SkuId;
    /**
     * The SkuPartNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SkuPartNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The TotalLicenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalLicenses;
    /**
     * Constructor method for Subscription
     * @uses Subscription::setDateCreated()
     * @uses Subscription::setIsTrial()
     * @uses Subscription::setNextLifecycleDate()
     * @uses Subscription::setObjectId()
     * @uses Subscription::setOcpSubscriptionId()
     * @uses Subscription::setOwnerContextId()
     * @uses Subscription::setOwnerObjectId()
     * @uses Subscription::setOwnerType()
     * @uses Subscription::setServiceStatus()
     * @uses Subscription::setSkuId()
     * @uses Subscription::setSkuPartNumber()
     * @uses Subscription::setStatus()
     * @uses Subscription::setTotalLicenses()
     * @param string $dateCreated
     * @param bool $isTrial
     * @param string $nextLifecycleDate
     * @param string $objectId
     * @param string $ocpSubscriptionId
     * @param string $ownerContextId
     * @param string $ownerObjectId
     * @param string $ownerType
     * @param \ArrayType\ArrayOfServiceStatus $serviceStatus
     * @param string $skuId
     * @param string $skuPartNumber
     * @param string $status
     * @param int $totalLicenses
     */
    public function __construct($dateCreated = null, $isTrial = null, $nextLifecycleDate = null, $objectId = null, $ocpSubscriptionId = null, $ownerContextId = null, $ownerObjectId = null, $ownerType = null, \ArrayType\ArrayOfServiceStatus $serviceStatus = null, $skuId = null, $skuPartNumber = null, $status = null, $totalLicenses = null)
    {
        $this
            ->setDateCreated($dateCreated)
            ->setIsTrial($isTrial)
            ->setNextLifecycleDate($nextLifecycleDate)
            ->setObjectId($objectId)
            ->setOcpSubscriptionId($ocpSubscriptionId)
            ->setOwnerContextId($ownerContextId)
            ->setOwnerObjectId($ownerObjectId)
            ->setOwnerType($ownerType)
            ->setServiceStatus($serviceStatus)
            ->setSkuId($skuId)
            ->setSkuPartNumber($skuPartNumber)
            ->setStatus($status)
            ->setTotalLicenses($totalLicenses);
    }
    /**
     * Get DateCreated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateCreated()
    {
        return isset($this->DateCreated) ? $this->DateCreated : null;
    }
    /**
     * Set DateCreated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateCreated
     * @return \StructType\Subscription
     */
    public function setDateCreated($dateCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreated) && !is_string($dateCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCreated)), __LINE__);
        }
        if (is_null($dateCreated) || (is_array($dateCreated) && empty($dateCreated))) {
            unset($this->DateCreated);
        } else {
            $this->DateCreated = $dateCreated;
        }
        return $this;
    }
    /**
     * Get IsTrial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTrial()
    {
        return isset($this->IsTrial) ? $this->IsTrial : null;
    }
    /**
     * Set IsTrial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTrial
     * @return \StructType\Subscription
     */
    public function setIsTrial($isTrial = null)
    {
        if (is_null($isTrial) || (is_array($isTrial) && empty($isTrial))) {
            unset($this->IsTrial);
        } else {
            $this->IsTrial = $isTrial;
        }
        return $this;
    }
    /**
     * Get NextLifecycleDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextLifecycleDate()
    {
        return isset($this->NextLifecycleDate) ? $this->NextLifecycleDate : null;
    }
    /**
     * Set NextLifecycleDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextLifecycleDate
     * @return \StructType\Subscription
     */
    public function setNextLifecycleDate($nextLifecycleDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextLifecycleDate) && !is_string($nextLifecycleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextLifecycleDate)), __LINE__);
        }
        if (is_null($nextLifecycleDate) || (is_array($nextLifecycleDate) && empty($nextLifecycleDate))) {
            unset($this->NextLifecycleDate);
        } else {
            $this->NextLifecycleDate = $nextLifecycleDate;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\Subscription
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get OcpSubscriptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOcpSubscriptionId()
    {
        return isset($this->OcpSubscriptionId) ? $this->OcpSubscriptionId : null;
    }
    /**
     * Set OcpSubscriptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ocpSubscriptionId
     * @return \StructType\Subscription
     */
    public function setOcpSubscriptionId($ocpSubscriptionId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ocpSubscriptionId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $ocpSubscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($ocpSubscriptionId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ocpSubscriptionId) && !is_string($ocpSubscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ocpSubscriptionId)), __LINE__);
        }
        if (is_null($ocpSubscriptionId) || (is_array($ocpSubscriptionId) && empty($ocpSubscriptionId))) {
            unset($this->OcpSubscriptionId);
        } else {
            $this->OcpSubscriptionId = $ocpSubscriptionId;
        }
        return $this;
    }
    /**
     * Get OwnerContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerContextId()
    {
        return isset($this->OwnerContextId) ? $this->OwnerContextId : null;
    }
    /**
     * Set OwnerContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerContextId
     * @return \StructType\Subscription
     */
    public function setOwnerContextId($ownerContextId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ownerContextId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $ownerContextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($ownerContextId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ownerContextId) && !is_string($ownerContextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerContextId)), __LINE__);
        }
        if (is_null($ownerContextId) || (is_array($ownerContextId) && empty($ownerContextId))) {
            unset($this->OwnerContextId);
        } else {
            $this->OwnerContextId = $ownerContextId;
        }
        return $this;
    }
    /**
     * Get OwnerObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerObjectId()
    {
        return isset($this->OwnerObjectId) ? $this->OwnerObjectId : null;
    }
    /**
     * Set OwnerObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerObjectId
     * @return \StructType\Subscription
     */
    public function setOwnerObjectId($ownerObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ownerObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $ownerObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($ownerObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ownerObjectId) && !is_string($ownerObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerObjectId)), __LINE__);
        }
        if (is_null($ownerObjectId) || (is_array($ownerObjectId) && empty($ownerObjectId))) {
            unset($this->OwnerObjectId);
        } else {
            $this->OwnerObjectId = $ownerObjectId;
        }
        return $this;
    }
    /**
     * Get OwnerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerType()
    {
        return isset($this->OwnerType) ? $this->OwnerType : null;
    }
    /**
     * Set OwnerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerType
     * @return \StructType\Subscription
     */
    public function setOwnerType($ownerType = null)
    {
        // validation for constraint: string
        if (!is_null($ownerType) && !is_string($ownerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerType)), __LINE__);
        }
        if (is_null($ownerType) || (is_array($ownerType) && empty($ownerType))) {
            unset($this->OwnerType);
        } else {
            $this->OwnerType = $ownerType;
        }
        return $this;
    }
    /**
     * Get ServiceStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServiceStatus|null
     */
    public function getServiceStatus()
    {
        return isset($this->ServiceStatus) ? $this->ServiceStatus : null;
    }
    /**
     * Set ServiceStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServiceStatus $serviceStatus
     * @return \StructType\Subscription
     */
    public function setServiceStatus(\ArrayType\ArrayOfServiceStatus $serviceStatus = null)
    {
        if (is_null($serviceStatus) || (is_array($serviceStatus) && empty($serviceStatus))) {
            unset($this->ServiceStatus);
        } else {
            $this->ServiceStatus = $serviceStatus;
        }
        return $this;
    }
    /**
     * Get SkuId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSkuId()
    {
        return isset($this->SkuId) ? $this->SkuId : null;
    }
    /**
     * Set SkuId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $skuId
     * @return \StructType\Subscription
     */
    public function setSkuId($skuId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($skuId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $skuId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($skuId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($skuId) && !is_string($skuId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skuId)), __LINE__);
        }
        if (is_null($skuId) || (is_array($skuId) && empty($skuId))) {
            unset($this->SkuId);
        } else {
            $this->SkuId = $skuId;
        }
        return $this;
    }
    /**
     * Get SkuPartNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSkuPartNumber()
    {
        return isset($this->SkuPartNumber) ? $this->SkuPartNumber : null;
    }
    /**
     * Set SkuPartNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $skuPartNumber
     * @return \StructType\Subscription
     */
    public function setSkuPartNumber($skuPartNumber = null)
    {
        // validation for constraint: string
        if (!is_null($skuPartNumber) && !is_string($skuPartNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skuPartNumber)), __LINE__);
        }
        if (is_null($skuPartNumber) || (is_array($skuPartNumber) && empty($skuPartNumber))) {
            unset($this->SkuPartNumber);
        } else {
            $this->SkuPartNumber = $skuPartNumber;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\SubscriptionStatus::valueIsValid()
     * @uses \EnumType\SubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Subscription
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubscriptionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\SubscriptionStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TotalLicenses value
     * @return int|null
     */
    public function getTotalLicenses()
    {
        return $this->TotalLicenses;
    }
    /**
     * Set TotalLicenses value
     * @param int $totalLicenses
     * @return \StructType\Subscription
     */
    public function setTotalLicenses($totalLicenses = null)
    {
        // validation for constraint: int
        if (!is_null($totalLicenses) && !is_numeric($totalLicenses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalLicenses)), __LINE__);
        }
        $this->TotalLicenses = $totalLicenses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
