<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StrongAuthenticationUserDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StrongAuthenticationUserDetails
 * @subpackage Structs
 */
class StrongAuthenticationUserDetails extends AbstractStructBase
{
    /**
     * The AlternativePhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternativePhoneNumber;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The OldPin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldPin;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Pin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Pin;
    /**
     * Constructor method for StrongAuthenticationUserDetails
     * @uses StrongAuthenticationUserDetails::setAlternativePhoneNumber()
     * @uses StrongAuthenticationUserDetails::setEmail()
     * @uses StrongAuthenticationUserDetails::setOldPin()
     * @uses StrongAuthenticationUserDetails::setPhoneNumber()
     * @uses StrongAuthenticationUserDetails::setPin()
     * @param string $alternativePhoneNumber
     * @param string $email
     * @param string $oldPin
     * @param string $phoneNumber
     * @param string $pin
     */
    public function __construct($alternativePhoneNumber = null, $email = null, $oldPin = null, $phoneNumber = null, $pin = null)
    {
        $this
            ->setAlternativePhoneNumber($alternativePhoneNumber)
            ->setEmail($email)
            ->setOldPin($oldPin)
            ->setPhoneNumber($phoneNumber)
            ->setPin($pin);
    }
    /**
     * Get AlternativePhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternativePhoneNumber()
    {
        return isset($this->AlternativePhoneNumber) ? $this->AlternativePhoneNumber : null;
    }
    /**
     * Set AlternativePhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternativePhoneNumber
     * @return \StructType\StrongAuthenticationUserDetails
     */
    public function setAlternativePhoneNumber($alternativePhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($alternativePhoneNumber) && !is_string($alternativePhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternativePhoneNumber)), __LINE__);
        }
        if (is_null($alternativePhoneNumber) || (is_array($alternativePhoneNumber) && empty($alternativePhoneNumber))) {
            unset($this->AlternativePhoneNumber);
        } else {
            $this->AlternativePhoneNumber = $alternativePhoneNumber;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\StrongAuthenticationUserDetails
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get OldPin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldPin()
    {
        return isset($this->OldPin) ? $this->OldPin : null;
    }
    /**
     * Set OldPin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldPin
     * @return \StructType\StrongAuthenticationUserDetails
     */
    public function setOldPin($oldPin = null)
    {
        // validation for constraint: string
        if (!is_null($oldPin) && !is_string($oldPin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldPin)), __LINE__);
        }
        if (is_null($oldPin) || (is_array($oldPin) && empty($oldPin))) {
            unset($this->OldPin);
        } else {
            $this->OldPin = $oldPin;
        }
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\StrongAuthenticationUserDetails
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get Pin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPin()
    {
        return isset($this->Pin) ? $this->Pin : null;
    }
    /**
     * Set Pin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pin
     * @return \StructType\StrongAuthenticationUserDetails
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pin)), __LINE__);
        }
        if (is_null($pin) || (is_array($pin) && empty($pin))) {
            unset($this->Pin);
        } else {
            $this->Pin = $pin;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StrongAuthenticationUserDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
