<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StrongAuthenticationRequirement StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StrongAuthenticationRequirement
 * @subpackage Structs
 */
class StrongAuthenticationRequirement extends AbstractStructBase
{
    /**
     * The RelyingParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelyingParty;
    /**
     * The RememberDevicesNotIssuedBefore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RememberDevicesNotIssuedBefore;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * Constructor method for StrongAuthenticationRequirement
     * @uses StrongAuthenticationRequirement::setRelyingParty()
     * @uses StrongAuthenticationRequirement::setRememberDevicesNotIssuedBefore()
     * @uses StrongAuthenticationRequirement::setState()
     * @param string $relyingParty
     * @param string $rememberDevicesNotIssuedBefore
     * @param string $state
     */
    public function __construct($relyingParty = null, $rememberDevicesNotIssuedBefore = null, $state = null)
    {
        $this
            ->setRelyingParty($relyingParty)
            ->setRememberDevicesNotIssuedBefore($rememberDevicesNotIssuedBefore)
            ->setState($state);
    }
    /**
     * Get RelyingParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelyingParty()
    {
        return isset($this->RelyingParty) ? $this->RelyingParty : null;
    }
    /**
     * Set RelyingParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relyingParty
     * @return \StructType\StrongAuthenticationRequirement
     */
    public function setRelyingParty($relyingParty = null)
    {
        // validation for constraint: string
        if (!is_null($relyingParty) && !is_string($relyingParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relyingParty)), __LINE__);
        }
        if (is_null($relyingParty) || (is_array($relyingParty) && empty($relyingParty))) {
            unset($this->RelyingParty);
        } else {
            $this->RelyingParty = $relyingParty;
        }
        return $this;
    }
    /**
     * Get RememberDevicesNotIssuedBefore value
     * @return string|null
     */
    public function getRememberDevicesNotIssuedBefore()
    {
        return $this->RememberDevicesNotIssuedBefore;
    }
    /**
     * Set RememberDevicesNotIssuedBefore value
     * @param string $rememberDevicesNotIssuedBefore
     * @return \StructType\StrongAuthenticationRequirement
     */
    public function setRememberDevicesNotIssuedBefore($rememberDevicesNotIssuedBefore = null)
    {
        // validation for constraint: string
        if (!is_null($rememberDevicesNotIssuedBefore) && !is_string($rememberDevicesNotIssuedBefore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rememberDevicesNotIssuedBefore)), __LINE__);
        }
        $this->RememberDevicesNotIssuedBefore = $rememberDevicesNotIssuedBefore;
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\StrongAuthenticationRequirement
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StrongAuthenticationRequirement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
