<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StrongAuthenticationPhoneAppDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StrongAuthenticationPhoneAppDetail
 * @subpackage Structs
 */
class StrongAuthenticationPhoneAppDetail extends AbstractStructBase
{
    /**
     * The AuthenticationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AuthenticationType;
    /**
     * The DeviceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceName;
    /**
     * The DeviceTag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceTag;
    /**
     * The DeviceToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceToken;
    /**
     * The NotificationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NotificationType;
    /**
     * The OathSecretKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OathSecretKey;
    /**
     * The OathTokenTimeDrift
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OathTokenTimeDrift;
    /**
     * The PhoneAppVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneAppVersion;
    /**
     * Constructor method for StrongAuthenticationPhoneAppDetail
     * @uses StrongAuthenticationPhoneAppDetail::setAuthenticationType()
     * @uses StrongAuthenticationPhoneAppDetail::setDeviceName()
     * @uses StrongAuthenticationPhoneAppDetail::setDeviceTag()
     * @uses StrongAuthenticationPhoneAppDetail::setDeviceToken()
     * @uses StrongAuthenticationPhoneAppDetail::setNotificationType()
     * @uses StrongAuthenticationPhoneAppDetail::setOathSecretKey()
     * @uses StrongAuthenticationPhoneAppDetail::setOathTokenTimeDrift()
     * @uses StrongAuthenticationPhoneAppDetail::setPhoneAppVersion()
     * @param string $authenticationType
     * @param string $deviceName
     * @param string $deviceTag
     * @param string $deviceToken
     * @param string $notificationType
     * @param string $oathSecretKey
     * @param int $oathTokenTimeDrift
     * @param string $phoneAppVersion
     */
    public function __construct($authenticationType = null, $deviceName = null, $deviceTag = null, $deviceToken = null, $notificationType = null, $oathSecretKey = null, $oathTokenTimeDrift = null, $phoneAppVersion = null)
    {
        $this
            ->setAuthenticationType($authenticationType)
            ->setDeviceName($deviceName)
            ->setDeviceTag($deviceTag)
            ->setDeviceToken($deviceToken)
            ->setNotificationType($notificationType)
            ->setOathSecretKey($oathSecretKey)
            ->setOathTokenTimeDrift($oathTokenTimeDrift)
            ->setPhoneAppVersion($phoneAppVersion);
    }
    /**
     * Get AuthenticationType value
     * @return string|null
     */
    public function getAuthenticationType()
    {
        return $this->AuthenticationType;
    }
    /**
     * Set AuthenticationType value
     * @uses \EnumType\StrongAuthenticationPhoneAppAuthType::valueIsValid()
     * @uses \EnumType\StrongAuthenticationPhoneAppAuthType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationType
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public function setAuthenticationType($authenticationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StrongAuthenticationPhoneAppAuthType::valueIsValid($authenticationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationType, implode(', ', \EnumType\StrongAuthenticationPhoneAppAuthType::getValidValues())), __LINE__);
        }
        $this->AuthenticationType = $authenticationType;
        return $this;
    }
    /**
     * Get DeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceName()
    {
        return isset($this->DeviceName) ? $this->DeviceName : null;
    }
    /**
     * Set DeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceName
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceName)), __LINE__);
        }
        if (is_null($deviceName) || (is_array($deviceName) && empty($deviceName))) {
            unset($this->DeviceName);
        } else {
            $this->DeviceName = $deviceName;
        }
        return $this;
    }
    /**
     * Get DeviceTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceTag()
    {
        return isset($this->DeviceTag) ? $this->DeviceTag : null;
    }
    /**
     * Set DeviceTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceTag
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public function setDeviceTag($deviceTag = null)
    {
        // validation for constraint: string
        if (!is_null($deviceTag) && !is_string($deviceTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceTag)), __LINE__);
        }
        if (is_null($deviceTag) || (is_array($deviceTag) && empty($deviceTag))) {
            unset($this->DeviceTag);
        } else {
            $this->DeviceTag = $deviceTag;
        }
        return $this;
    }
    /**
     * Get DeviceToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceToken()
    {
        return isset($this->DeviceToken) ? $this->DeviceToken : null;
    }
    /**
     * Set DeviceToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceToken
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public function setDeviceToken($deviceToken = null)
    {
        // validation for constraint: string
        if (!is_null($deviceToken) && !is_string($deviceToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceToken)), __LINE__);
        }
        if (is_null($deviceToken) || (is_array($deviceToken) && empty($deviceToken))) {
            unset($this->DeviceToken);
        } else {
            $this->DeviceToken = $deviceToken;
        }
        return $this;
    }
    /**
     * Get NotificationType value
     * @return string|null
     */
    public function getNotificationType()
    {
        return $this->NotificationType;
    }
    /**
     * Set NotificationType value
     * @uses \EnumType\StrongAuthenticationPhoneAppNotificationType::valueIsValid()
     * @uses \EnumType\StrongAuthenticationPhoneAppNotificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notificationType
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public function setNotificationType($notificationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StrongAuthenticationPhoneAppNotificationType::valueIsValid($notificationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $notificationType, implode(', ', \EnumType\StrongAuthenticationPhoneAppNotificationType::getValidValues())), __LINE__);
        }
        $this->NotificationType = $notificationType;
        return $this;
    }
    /**
     * Get OathSecretKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOathSecretKey()
    {
        return isset($this->OathSecretKey) ? $this->OathSecretKey : null;
    }
    /**
     * Set OathSecretKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oathSecretKey
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public function setOathSecretKey($oathSecretKey = null)
    {
        // validation for constraint: string
        if (!is_null($oathSecretKey) && !is_string($oathSecretKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oathSecretKey)), __LINE__);
        }
        if (is_null($oathSecretKey) || (is_array($oathSecretKey) && empty($oathSecretKey))) {
            unset($this->OathSecretKey);
        } else {
            $this->OathSecretKey = $oathSecretKey;
        }
        return $this;
    }
    /**
     * Get OathTokenTimeDrift value
     * @return int|null
     */
    public function getOathTokenTimeDrift()
    {
        return $this->OathTokenTimeDrift;
    }
    /**
     * Set OathTokenTimeDrift value
     * @param int $oathTokenTimeDrift
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public function setOathTokenTimeDrift($oathTokenTimeDrift = null)
    {
        // validation for constraint: int
        if (!is_null($oathTokenTimeDrift) && !is_numeric($oathTokenTimeDrift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oathTokenTimeDrift)), __LINE__);
        }
        $this->OathTokenTimeDrift = $oathTokenTimeDrift;
        return $this;
    }
    /**
     * Get PhoneAppVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneAppVersion()
    {
        return isset($this->PhoneAppVersion) ? $this->PhoneAppVersion : null;
    }
    /**
     * Set PhoneAppVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneAppVersion
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public function setPhoneAppVersion($phoneAppVersion = null)
    {
        // validation for constraint: string
        if (!is_null($phoneAppVersion) && !is_string($phoneAppVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneAppVersion)), __LINE__);
        }
        if (is_null($phoneAppVersion) || (is_array($phoneAppVersion) && empty($phoneAppVersion))) {
            unset($this->PhoneAppVersion);
        } else {
            $this->PhoneAppVersion = $phoneAppVersion;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StrongAuthenticationPhoneAppDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
