<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StrongAuthenticationMethod StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StrongAuthenticationMethod
 * @subpackage Structs
 */
class StrongAuthenticationMethod extends AbstractStructBase
{
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDefault;
    /**
     * The MethodType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodType;
    /**
     * Constructor method for StrongAuthenticationMethod
     * @uses StrongAuthenticationMethod::setIsDefault()
     * @uses StrongAuthenticationMethod::setMethodType()
     * @param bool $isDefault
     * @param string $methodType
     */
    public function __construct($isDefault = null, $methodType = null)
    {
        $this
            ->setIsDefault($isDefault)
            ->setMethodType($methodType);
    }
    /**
     * Get IsDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\StrongAuthenticationMethod
     */
    public function setIsDefault($isDefault = null)
    {
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get MethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodType()
    {
        return isset($this->MethodType) ? $this->MethodType : null;
    }
    /**
     * Set MethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodType
     * @return \StructType\StrongAuthenticationMethod
     */
    public function setMethodType($methodType = null)
    {
        // validation for constraint: string
        if (!is_null($methodType) && !is_string($methodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($methodType)), __LINE__);
        }
        if (is_null($methodType) || (is_array($methodType) && empty($methodType))) {
            unset($this->MethodType);
        } else {
            $this->MethodType = $methodType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StrongAuthenticationMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
