<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetUserLicensesByUpnRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SetUserLicensesByUpnRequest
 * @subpackage Structs
 */
class SetUserLicensesByUpnRequest extends Request
{
    /**
     * The AddLicenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountSkuIdentifier
     */
    public $AddLicenses;
    /**
     * The LicenseOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLicenseOption
     */
    public $LicenseOptions;
    /**
     * The RemoveLicenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountSkuIdentifier
     */
    public $RemoveLicenses;
    /**
     * The UserPrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPrincipalName;
    /**
     * Constructor method for SetUserLicensesByUpnRequest
     * @uses SetUserLicensesByUpnRequest::setAddLicenses()
     * @uses SetUserLicensesByUpnRequest::setLicenseOptions()
     * @uses SetUserLicensesByUpnRequest::setRemoveLicenses()
     * @uses SetUserLicensesByUpnRequest::setUserPrincipalName()
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $addLicenses
     * @param \ArrayType\ArrayOfLicenseOption $licenseOptions
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $removeLicenses
     * @param string $userPrincipalName
     */
    public function __construct(\ArrayType\ArrayOfAccountSkuIdentifier $addLicenses = null, \ArrayType\ArrayOfLicenseOption $licenseOptions = null, \ArrayType\ArrayOfAccountSkuIdentifier $removeLicenses = null, $userPrincipalName = null)
    {
        $this
            ->setAddLicenses($addLicenses)
            ->setLicenseOptions($licenseOptions)
            ->setRemoveLicenses($removeLicenses)
            ->setUserPrincipalName($userPrincipalName);
    }
    /**
     * Get AddLicenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountSkuIdentifier|null
     */
    public function getAddLicenses()
    {
        return isset($this->AddLicenses) ? $this->AddLicenses : null;
    }
    /**
     * Set AddLicenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $addLicenses
     * @return \StructType\SetUserLicensesByUpnRequest
     */
    public function setAddLicenses(\ArrayType\ArrayOfAccountSkuIdentifier $addLicenses = null)
    {
        if (is_null($addLicenses) || (is_array($addLicenses) && empty($addLicenses))) {
            unset($this->AddLicenses);
        } else {
            $this->AddLicenses = $addLicenses;
        }
        return $this;
    }
    /**
     * Get LicenseOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLicenseOption|null
     */
    public function getLicenseOptions()
    {
        return isset($this->LicenseOptions) ? $this->LicenseOptions : null;
    }
    /**
     * Set LicenseOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLicenseOption $licenseOptions
     * @return \StructType\SetUserLicensesByUpnRequest
     */
    public function setLicenseOptions(\ArrayType\ArrayOfLicenseOption $licenseOptions = null)
    {
        if (is_null($licenseOptions) || (is_array($licenseOptions) && empty($licenseOptions))) {
            unset($this->LicenseOptions);
        } else {
            $this->LicenseOptions = $licenseOptions;
        }
        return $this;
    }
    /**
     * Get RemoveLicenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountSkuIdentifier|null
     */
    public function getRemoveLicenses()
    {
        return isset($this->RemoveLicenses) ? $this->RemoveLicenses : null;
    }
    /**
     * Set RemoveLicenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $removeLicenses
     * @return \StructType\SetUserLicensesByUpnRequest
     */
    public function setRemoveLicenses(\ArrayType\ArrayOfAccountSkuIdentifier $removeLicenses = null)
    {
        if (is_null($removeLicenses) || (is_array($removeLicenses) && empty($removeLicenses))) {
            unset($this->RemoveLicenses);
        } else {
            $this->RemoveLicenses = $removeLicenses;
        }
        return $this;
    }
    /**
     * Get UserPrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPrincipalName()
    {
        return isset($this->UserPrincipalName) ? $this->UserPrincipalName : null;
    }
    /**
     * Set UserPrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPrincipalName
     * @return \StructType\SetUserLicensesByUpnRequest
     */
    public function setUserPrincipalName($userPrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($userPrincipalName) && !is_string($userPrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPrincipalName)), __LINE__);
        }
        if (is_null($userPrincipalName) || (is_array($userPrincipalName) && empty($userPrincipalName))) {
            unset($this->UserPrincipalName);
        } else {
            $this->UserPrincipalName = $userPrincipalName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetUserLicensesByUpnRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
