<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceStatus StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceStatus
 * @subpackage Structs
 */
class ServiceStatus extends AbstractStructBase
{
    /**
     * The ProvisioningStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProvisioningStatus;
    /**
     * The ServicePlan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServicePlan
     */
    public $ServicePlan;
    /**
     * Constructor method for ServiceStatus
     * @uses ServiceStatus::setProvisioningStatus()
     * @uses ServiceStatus::setServicePlan()
     * @param string $provisioningStatus
     * @param \StructType\ServicePlan $servicePlan
     */
    public function __construct($provisioningStatus = null, \StructType\ServicePlan $servicePlan = null)
    {
        $this
            ->setProvisioningStatus($provisioningStatus)
            ->setServicePlan($servicePlan);
    }
    /**
     * Get ProvisioningStatus value
     * @return string|null
     */
    public function getProvisioningStatus()
    {
        return $this->ProvisioningStatus;
    }
    /**
     * Set ProvisioningStatus value
     * @uses \EnumType\ProvisioningStatus::valueIsValid()
     * @uses \EnumType\ProvisioningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $provisioningStatus
     * @return \StructType\ServiceStatus
     */
    public function setProvisioningStatus($provisioningStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProvisioningStatus::valueIsValid($provisioningStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $provisioningStatus, implode(', ', \EnumType\ProvisioningStatus::getValidValues())), __LINE__);
        }
        $this->ProvisioningStatus = $provisioningStatus;
        return $this;
    }
    /**
     * Get ServicePlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServicePlan|null
     */
    public function getServicePlan()
    {
        return isset($this->ServicePlan) ? $this->ServicePlan : null;
    }
    /**
     * Set ServicePlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServicePlan $servicePlan
     * @return \StructType\ServiceStatus
     */
    public function setServicePlan(\StructType\ServicePlan $servicePlan = null)
    {
        if (is_null($servicePlan) || (is_array($servicePlan) && empty($servicePlan))) {
            unset($this->ServicePlan);
        } else {
            $this->ServicePlan = $servicePlan;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
