<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePrincipalCredential StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServicePrincipalCredential
 * @subpackage Structs
 */
class ServicePrincipalCredential extends AbstractStructBase
{
    /**
     * The ApplicationKeyIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationKeyIdentifier;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The KeyGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $KeyGroupId;
    /**
     * The KeyId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $KeyId;
    /**
     * The KeyReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KeyReference;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Usage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Usage;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ServicePrincipalCredential
     * @uses ServicePrincipalCredential::setApplicationKeyIdentifier()
     * @uses ServicePrincipalCredential::setEndDate()
     * @uses ServicePrincipalCredential::setKeyGroupId()
     * @uses ServicePrincipalCredential::setKeyId()
     * @uses ServicePrincipalCredential::setKeyReference()
     * @uses ServicePrincipalCredential::setStartDate()
     * @uses ServicePrincipalCredential::setType()
     * @uses ServicePrincipalCredential::setUsage()
     * @uses ServicePrincipalCredential::setValue()
     * @param string $applicationKeyIdentifier
     * @param string $endDate
     * @param string $keyGroupId
     * @param string $keyId
     * @param string $keyReference
     * @param string $startDate
     * @param string $type
     * @param string $usage
     * @param string $value
     */
    public function __construct($applicationKeyIdentifier = null, $endDate = null, $keyGroupId = null, $keyId = null, $keyReference = null, $startDate = null, $type = null, $usage = null, $value = null)
    {
        $this
            ->setApplicationKeyIdentifier($applicationKeyIdentifier)
            ->setEndDate($endDate)
            ->setKeyGroupId($keyGroupId)
            ->setKeyId($keyId)
            ->setKeyReference($keyReference)
            ->setStartDate($startDate)
            ->setType($type)
            ->setUsage($usage)
            ->setValue($value);
    }
    /**
     * Get ApplicationKeyIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationKeyIdentifier()
    {
        return isset($this->ApplicationKeyIdentifier) ? $this->ApplicationKeyIdentifier : null;
    }
    /**
     * Set ApplicationKeyIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationKeyIdentifier
     * @return \StructType\ServicePrincipalCredential
     */
    public function setApplicationKeyIdentifier($applicationKeyIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($applicationKeyIdentifier) && !is_string($applicationKeyIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationKeyIdentifier)), __LINE__);
        }
        if (is_null($applicationKeyIdentifier) || (is_array($applicationKeyIdentifier) && empty($applicationKeyIdentifier))) {
            unset($this->ApplicationKeyIdentifier);
        } else {
            $this->ApplicationKeyIdentifier = $applicationKeyIdentifier;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \StructType\ServicePrincipalCredential
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get KeyGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeyGroupId()
    {
        return isset($this->KeyGroupId) ? $this->KeyGroupId : null;
    }
    /**
     * Set KeyGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keyGroupId
     * @return \StructType\ServicePrincipalCredential
     */
    public function setKeyGroupId($keyGroupId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($keyGroupId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $keyGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($keyGroupId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($keyGroupId) && !is_string($keyGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyGroupId)), __LINE__);
        }
        if (is_null($keyGroupId) || (is_array($keyGroupId) && empty($keyGroupId))) {
            unset($this->KeyGroupId);
        } else {
            $this->KeyGroupId = $keyGroupId;
        }
        return $this;
    }
    /**
     * Get KeyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeyId()
    {
        return isset($this->KeyId) ? $this->KeyId : null;
    }
    /**
     * Set KeyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keyId
     * @return \StructType\ServicePrincipalCredential
     */
    public function setKeyId($keyId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($keyId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $keyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($keyId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($keyId) && !is_string($keyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyId)), __LINE__);
        }
        if (is_null($keyId) || (is_array($keyId) && empty($keyId))) {
            unset($this->KeyId);
        } else {
            $this->KeyId = $keyId;
        }
        return $this;
    }
    /**
     * Get KeyReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeyReference()
    {
        return isset($this->KeyReference) ? $this->KeyReference : null;
    }
    /**
     * Set KeyReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keyReference
     * @return \StructType\ServicePrincipalCredential
     */
    public function setKeyReference($keyReference = null)
    {
        // validation for constraint: string
        if (!is_null($keyReference) && !is_string($keyReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyReference)), __LINE__);
        }
        if (is_null($keyReference) || (is_array($keyReference) && empty($keyReference))) {
            unset($this->KeyReference);
        } else {
            $this->KeyReference = $keyReference;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \StructType\ServicePrincipalCredential
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ServicePrincipalCredentialType::valueIsValid()
     * @uses \EnumType\ServicePrincipalCredentialType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ServicePrincipalCredential
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServicePrincipalCredentialType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ServicePrincipalCredentialType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Usage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsage()
    {
        return isset($this->Usage) ? $this->Usage : null;
    }
    /**
     * Set Usage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ServicePrincipalCredentialUsage::valueIsValid()
     * @uses \EnumType\ServicePrincipalCredentialUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \StructType\ServicePrincipalCredential
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServicePrincipalCredentialUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usage, implode(', ', \EnumType\ServicePrincipalCredentialUsage::getValidValues())), __LINE__);
        }
        if (is_null($usage) || (is_array($usage) && empty($usage))) {
            unset($this->Usage);
        } else {
            $this->Usage = $usage;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\ServicePrincipalCredential
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServicePrincipalCredential
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
