<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoleMember StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoleMember
 * @subpackage Structs
 */
class RoleMember extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The IsLicensed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLicensed;
    /**
     * The LastDirSyncTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDirSyncTime;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The OverallProvisioningStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OverallProvisioningStatus;
    /**
     * The RoleMemberType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoleMemberType;
    /**
     * The StrongAuthenticationRequirements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStrongAuthenticationRequirement
     */
    public $StrongAuthenticationRequirements;
    /**
     * The ValidationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationStatus;
    /**
     * Constructor method for RoleMember
     * @uses RoleMember::setDisplayName()
     * @uses RoleMember::setEmailAddress()
     * @uses RoleMember::setIsLicensed()
     * @uses RoleMember::setLastDirSyncTime()
     * @uses RoleMember::setObjectId()
     * @uses RoleMember::setOverallProvisioningStatus()
     * @uses RoleMember::setRoleMemberType()
     * @uses RoleMember::setStrongAuthenticationRequirements()
     * @uses RoleMember::setValidationStatus()
     * @param string $displayName
     * @param string $emailAddress
     * @param bool $isLicensed
     * @param string $lastDirSyncTime
     * @param string $objectId
     * @param string $overallProvisioningStatus
     * @param string $roleMemberType
     * @param \ArrayType\ArrayOfStrongAuthenticationRequirement $strongAuthenticationRequirements
     * @param string $validationStatus
     */
    public function __construct($displayName = null, $emailAddress = null, $isLicensed = null, $lastDirSyncTime = null, $objectId = null, $overallProvisioningStatus = null, $roleMemberType = null, \ArrayType\ArrayOfStrongAuthenticationRequirement $strongAuthenticationRequirements = null, $validationStatus = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setEmailAddress($emailAddress)
            ->setIsLicensed($isLicensed)
            ->setLastDirSyncTime($lastDirSyncTime)
            ->setObjectId($objectId)
            ->setOverallProvisioningStatus($overallProvisioningStatus)
            ->setRoleMemberType($roleMemberType)
            ->setStrongAuthenticationRequirements($strongAuthenticationRequirements)
            ->setValidationStatus($validationStatus);
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\RoleMember
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\RoleMember
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get IsLicensed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLicensed()
    {
        return isset($this->IsLicensed) ? $this->IsLicensed : null;
    }
    /**
     * Set IsLicensed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLicensed
     * @return \StructType\RoleMember
     */
    public function setIsLicensed($isLicensed = null)
    {
        if (is_null($isLicensed) || (is_array($isLicensed) && empty($isLicensed))) {
            unset($this->IsLicensed);
        } else {
            $this->IsLicensed = $isLicensed;
        }
        return $this;
    }
    /**
     * Get LastDirSyncTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDirSyncTime()
    {
        return isset($this->LastDirSyncTime) ? $this->LastDirSyncTime : null;
    }
    /**
     * Set LastDirSyncTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDirSyncTime
     * @return \StructType\RoleMember
     */
    public function setLastDirSyncTime($lastDirSyncTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDirSyncTime) && !is_string($lastDirSyncTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDirSyncTime)), __LINE__);
        }
        if (is_null($lastDirSyncTime) || (is_array($lastDirSyncTime) && empty($lastDirSyncTime))) {
            unset($this->LastDirSyncTime);
        } else {
            $this->LastDirSyncTime = $lastDirSyncTime;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\RoleMember
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get OverallProvisioningStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverallProvisioningStatus()
    {
        return isset($this->OverallProvisioningStatus) ? $this->OverallProvisioningStatus : null;
    }
    /**
     * Set OverallProvisioningStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ProvisioningStatus::valueIsValid()
     * @uses \EnumType\ProvisioningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallProvisioningStatus
     * @return \StructType\RoleMember
     */
    public function setOverallProvisioningStatus($overallProvisioningStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProvisioningStatus::valueIsValid($overallProvisioningStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $overallProvisioningStatus, implode(', ', \EnumType\ProvisioningStatus::getValidValues())), __LINE__);
        }
        if (is_null($overallProvisioningStatus) || (is_array($overallProvisioningStatus) && empty($overallProvisioningStatus))) {
            unset($this->OverallProvisioningStatus);
        } else {
            $this->OverallProvisioningStatus = $overallProvisioningStatus;
        }
        return $this;
    }
    /**
     * Get RoleMemberType value
     * @return string|null
     */
    public function getRoleMemberType()
    {
        return $this->RoleMemberType;
    }
    /**
     * Set RoleMemberType value
     * @uses \EnumType\RoleMemberType::valueIsValid()
     * @uses \EnumType\RoleMemberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleMemberType
     * @return \StructType\RoleMember
     */
    public function setRoleMemberType($roleMemberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoleMemberType::valueIsValid($roleMemberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roleMemberType, implode(', ', \EnumType\RoleMemberType::getValidValues())), __LINE__);
        }
        $this->RoleMemberType = $roleMemberType;
        return $this;
    }
    /**
     * Get StrongAuthenticationRequirements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStrongAuthenticationRequirement|null
     */
    public function getStrongAuthenticationRequirements()
    {
        return isset($this->StrongAuthenticationRequirements) ? $this->StrongAuthenticationRequirements : null;
    }
    /**
     * Set StrongAuthenticationRequirements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStrongAuthenticationRequirement $strongAuthenticationRequirements
     * @return \StructType\RoleMember
     */
    public function setStrongAuthenticationRequirements(\ArrayType\ArrayOfStrongAuthenticationRequirement $strongAuthenticationRequirements = null)
    {
        if (is_null($strongAuthenticationRequirements) || (is_array($strongAuthenticationRequirements) && empty($strongAuthenticationRequirements))) {
            unset($this->StrongAuthenticationRequirements);
        } else {
            $this->StrongAuthenticationRequirements = $strongAuthenticationRequirements;
        }
        return $this;
    }
    /**
     * Get ValidationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationStatus()
    {
        return isset($this->ValidationStatus) ? $this->ValidationStatus : null;
    }
    /**
     * Set ValidationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ValidationStatus::valueIsValid()
     * @uses \EnumType\ValidationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validationStatus
     * @return \StructType\RoleMember
     */
    public function setValidationStatus($validationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValidationStatus::valueIsValid($validationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $validationStatus, implode(', ', \EnumType\ValidationStatus::getValidValues())), __LINE__);
        }
        if (is_null($validationStatus) || (is_array($validationStatus) && empty($validationStatus))) {
            unset($this->ValidationStatus);
        } else {
            $this->ValidationStatus = $validationStatus;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoleMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
