<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResetUserPasswordRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResetUserPasswordRequest
 * @subpackage Structs
 */
class ResetUserPasswordRequest extends Request
{
    /**
     * The ForceChangePassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ForceChangePassword;
    /**
     * The ForceChangePasswordOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ForceChangePasswordOnly;
    /**
     * The NewPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewPassword;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * Constructor method for ResetUserPasswordRequest
     * @uses ResetUserPasswordRequest::setForceChangePassword()
     * @uses ResetUserPasswordRequest::setForceChangePasswordOnly()
     * @uses ResetUserPasswordRequest::setNewPassword()
     * @uses ResetUserPasswordRequest::setObjectId()
     * @param bool $forceChangePassword
     * @param bool $forceChangePasswordOnly
     * @param string $newPassword
     * @param string $objectId
     */
    public function __construct($forceChangePassword = null, $forceChangePasswordOnly = null, $newPassword = null, $objectId = null)
    {
        $this
            ->setForceChangePassword($forceChangePassword)
            ->setForceChangePasswordOnly($forceChangePasswordOnly)
            ->setNewPassword($newPassword)
            ->setObjectId($objectId);
    }
    /**
     * Get ForceChangePassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceChangePassword()
    {
        return isset($this->ForceChangePassword) ? $this->ForceChangePassword : null;
    }
    /**
     * Set ForceChangePassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceChangePassword
     * @return \StructType\ResetUserPasswordRequest
     */
    public function setForceChangePassword($forceChangePassword = null)
    {
        if (is_null($forceChangePassword) || (is_array($forceChangePassword) && empty($forceChangePassword))) {
            unset($this->ForceChangePassword);
        } else {
            $this->ForceChangePassword = $forceChangePassword;
        }
        return $this;
    }
    /**
     * Get ForceChangePasswordOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceChangePasswordOnly()
    {
        return isset($this->ForceChangePasswordOnly) ? $this->ForceChangePasswordOnly : null;
    }
    /**
     * Set ForceChangePasswordOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceChangePasswordOnly
     * @return \StructType\ResetUserPasswordRequest
     */
    public function setForceChangePasswordOnly($forceChangePasswordOnly = null)
    {
        if (is_null($forceChangePasswordOnly) || (is_array($forceChangePasswordOnly) && empty($forceChangePasswordOnly))) {
            unset($this->ForceChangePasswordOnly);
        } else {
            $this->ForceChangePasswordOnly = $forceChangePasswordOnly;
        }
        return $this;
    }
    /**
     * Get NewPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPassword()
    {
        return isset($this->NewPassword) ? $this->NewPassword : null;
    }
    /**
     * Set NewPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPassword
     * @return \StructType\ResetUserPasswordRequest
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPassword)), __LINE__);
        }
        if (is_null($newPassword) || (is_array($newPassword) && empty($newPassword))) {
            unset($this->NewPassword);
        } else {
            $this->NewPassword = $newPassword;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \StructType\ResetUserPasswordRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResetUserPasswordRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
