<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveGroupMembersRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RemoveGroupMembersRequest
 * @subpackage Structs
 */
class RemoveGroupMembersRequest extends Request
{
    /**
     * The GroupMembers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGroupMember
     */
    public $GroupMembers;
    /**
     * The GroupObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupObjectId;
    /**
     * Constructor method for RemoveGroupMembersRequest
     * @uses RemoveGroupMembersRequest::setGroupMembers()
     * @uses RemoveGroupMembersRequest::setGroupObjectId()
     * @param \ArrayType\ArrayOfGroupMember $groupMembers
     * @param string $groupObjectId
     */
    public function __construct(\ArrayType\ArrayOfGroupMember $groupMembers = null, $groupObjectId = null)
    {
        $this
            ->setGroupMembers($groupMembers)
            ->setGroupObjectId($groupObjectId);
    }
    /**
     * Get GroupMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGroupMember|null
     */
    public function getGroupMembers()
    {
        return isset($this->GroupMembers) ? $this->GroupMembers : null;
    }
    /**
     * Set GroupMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGroupMember $groupMembers
     * @return \StructType\RemoveGroupMembersRequest
     */
    public function setGroupMembers(\ArrayType\ArrayOfGroupMember $groupMembers = null)
    {
        if (is_null($groupMembers) || (is_array($groupMembers) && empty($groupMembers))) {
            unset($this->GroupMembers);
        } else {
            $this->GroupMembers = $groupMembers;
        }
        return $this;
    }
    /**
     * Get GroupObjectId value
     * @return string|null
     */
    public function getGroupObjectId()
    {
        return $this->GroupObjectId;
    }
    /**
     * Set GroupObjectId value
     * @param string $groupObjectId
     * @return \StructType\RemoveGroupMembersRequest
     */
    public function setGroupObjectId($groupObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($groupObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $groupObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($groupObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groupObjectId) && !is_string($groupObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupObjectId)), __LINE__);
        }
        $this->GroupObjectId = $groupObjectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveGroupMembersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
