<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyValidationException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PropertyValidationException
 * @subpackage Structs
 */
class PropertyValidationException extends MsolAdministrationException
{
    /**
     * The ParentObjectType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParentObjectType;
    /**
     * The PropertyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyName;
    /**
     * Constructor method for PropertyValidationException
     * @uses PropertyValidationException::setParentObjectType()
     * @uses PropertyValidationException::setPropertyName()
     * @param string $parentObjectType
     * @param string $propertyName
     */
    public function __construct($parentObjectType = null, $propertyName = null)
    {
        $this
            ->setParentObjectType($parentObjectType)
            ->setPropertyName($propertyName);
    }
    /**
     * Get ParentObjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentObjectType()
    {
        return isset($this->ParentObjectType) ? $this->ParentObjectType : null;
    }
    /**
     * Set ParentObjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentObjectType
     * @return \StructType\PropertyValidationException
     */
    public function setParentObjectType($parentObjectType = null)
    {
        // validation for constraint: string
        if (!is_null($parentObjectType) && !is_string($parentObjectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentObjectType)), __LINE__);
        }
        if (is_null($parentObjectType) || (is_array($parentObjectType) && empty($parentObjectType))) {
            unset($this->ParentObjectType);
        } else {
            $this->ParentObjectType = $parentObjectType;
        }
        return $this;
    }
    /**
     * Get PropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyName()
    {
        return isset($this->PropertyName) ? $this->PropertyName : null;
    }
    /**
     * Set PropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyName
     * @return \StructType\PropertyValidationException
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyName)), __LINE__);
        }
        if (is_null($propertyName) || (is_array($propertyName) && empty($propertyName))) {
            unset($this->PropertyName);
        } else {
            $this->PropertyName = $propertyName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyValidationException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
