<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NavigateContactResultsRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NavigateContactResultsRequest
 * @subpackage Structs
 */
class NavigateContactResultsRequest extends Request
{
    /**
     * The ListContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListContext;
    /**
     * The PageToNavigate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PageToNavigate;
    /**
     * Constructor method for NavigateContactResultsRequest
     * @uses NavigateContactResultsRequest::setListContext()
     * @uses NavigateContactResultsRequest::setPageToNavigate()
     * @param string $listContext
     * @param string $pageToNavigate
     */
    public function __construct($listContext = null, $pageToNavigate = null)
    {
        $this
            ->setListContext($listContext)
            ->setPageToNavigate($pageToNavigate);
    }
    /**
     * Get ListContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListContext()
    {
        return isset($this->ListContext) ? $this->ListContext : null;
    }
    /**
     * Set ListContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listContext
     * @return \StructType\NavigateContactResultsRequest
     */
    public function setListContext($listContext = null)
    {
        // validation for constraint: string
        if (!is_null($listContext) && !is_string($listContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listContext)), __LINE__);
        }
        if (is_null($listContext) || (is_array($listContext) && empty($listContext))) {
            unset($this->ListContext);
        } else {
            $this->ListContext = $listContext;
        }
        return $this;
    }
    /**
     * Get PageToNavigate value
     * @return string|null
     */
    public function getPageToNavigate()
    {
        return $this->PageToNavigate;
    }
    /**
     * Set PageToNavigate value
     * @uses \EnumType\Page::valueIsValid()
     * @uses \EnumType\Page::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pageToNavigate
     * @return \StructType\NavigateContactResultsRequest
     */
    public function setPageToNavigate($pageToNavigate = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Page::valueIsValid($pageToNavigate)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pageToNavigate, implode(', ', \EnumType\Page::getValidValues())), __LINE__);
        }
        $this->PageToNavigate = $pageToNavigate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NavigateContactResultsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
