<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsolAdministrationException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MsolAdministrationException
 * @subpackage Structs
 */
class MsolAdministrationException extends AbstractStructBase
{
    /**
     * The HelpLink
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HelpLink;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The OperationId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperationId;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Source;
    /**
     * The StackTrace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StackTrace;
    /**
     * Constructor method for MsolAdministrationException
     * @uses MsolAdministrationException::setHelpLink()
     * @uses MsolAdministrationException::setMessage()
     * @uses MsolAdministrationException::setOperationId()
     * @uses MsolAdministrationException::setSource()
     * @uses MsolAdministrationException::setStackTrace()
     * @param string $helpLink
     * @param string $message
     * @param string $operationId
     * @param string $source
     * @param string $stackTrace
     */
    public function __construct($helpLink = null, $message = null, $operationId = null, $source = null, $stackTrace = null)
    {
        $this
            ->setHelpLink($helpLink)
            ->setMessage($message)
            ->setOperationId($operationId)
            ->setSource($source)
            ->setStackTrace($stackTrace);
    }
    /**
     * Get HelpLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHelpLink()
    {
        return isset($this->HelpLink) ? $this->HelpLink : null;
    }
    /**
     * Set HelpLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $helpLink
     * @return \StructType\MsolAdministrationException
     */
    public function setHelpLink($helpLink = null)
    {
        // validation for constraint: string
        if (!is_null($helpLink) && !is_string($helpLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($helpLink)), __LINE__);
        }
        if (is_null($helpLink) || (is_array($helpLink) && empty($helpLink))) {
            unset($this->HelpLink);
        } else {
            $this->HelpLink = $helpLink;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\MsolAdministrationException
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get OperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationId()
    {
        return isset($this->OperationId) ? $this->OperationId : null;
    }
    /**
     * Set OperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationId
     * @return \StructType\MsolAdministrationException
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($operationId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($operationId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationId)), __LINE__);
        }
        if (is_null($operationId) || (is_array($operationId) && empty($operationId))) {
            unset($this->OperationId);
        } else {
            $this->OperationId = $operationId;
        }
        return $this;
    }
    /**
     * Get Source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->Source) ? $this->Source : null;
    }
    /**
     * Set Source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \StructType\MsolAdministrationException
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->Source);
        } else {
            $this->Source = $source;
        }
        return $this;
    }
    /**
     * Get StackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStackTrace()
    {
        return isset($this->StackTrace) ? $this->StackTrace : null;
    }
    /**
     * Set StackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stackTrace
     * @return \StructType\MsolAdministrationException
     */
    public function setStackTrace($stackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($stackTrace) && !is_string($stackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stackTrace)), __LINE__);
        }
        if (is_null($stackTrace) || (is_array($stackTrace) && empty($stackTrace))) {
            unset($this->StackTrace);
        } else {
            $this->StackTrace = $stackTrace;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MsolAdministrationException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
