<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListServicePrincipalCredentialsByAppPrincipalIdRequest
 * StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ListServicePrincipalCredentialsByAppPrincipalIdRequest
 * @subpackage Structs
 */
class ListServicePrincipalCredentialsByAppPrincipalIdRequest extends Request
{
    /**
     * The AppPrincipalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppPrincipalId;
    /**
     * The ReturnKeyValues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnKeyValues;
    /**
     * Constructor method for ListServicePrincipalCredentialsByAppPrincipalIdRequest
     * @uses ListServicePrincipalCredentialsByAppPrincipalIdRequest::setAppPrincipalId()
     * @uses ListServicePrincipalCredentialsByAppPrincipalIdRequest::setReturnKeyValues()
     * @param string $appPrincipalId
     * @param bool $returnKeyValues
     */
    public function __construct($appPrincipalId = null, $returnKeyValues = null)
    {
        $this
            ->setAppPrincipalId($appPrincipalId)
            ->setReturnKeyValues($returnKeyValues);
    }
    /**
     * Get AppPrincipalId value
     * @return string|null
     */
    public function getAppPrincipalId()
    {
        return $this->AppPrincipalId;
    }
    /**
     * Set AppPrincipalId value
     * @param string $appPrincipalId
     * @return \StructType\ListServicePrincipalCredentialsByAppPrincipalIdRequest
     */
    public function setAppPrincipalId($appPrincipalId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($appPrincipalId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $appPrincipalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($appPrincipalId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($appPrincipalId) && !is_string($appPrincipalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appPrincipalId)), __LINE__);
        }
        $this->AppPrincipalId = $appPrincipalId;
        return $this;
    }
    /**
     * Get ReturnKeyValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnKeyValues()
    {
        return isset($this->ReturnKeyValues) ? $this->ReturnKeyValues : null;
    }
    /**
     * Set ReturnKeyValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnKeyValues
     * @return \StructType\ListServicePrincipalCredentialsByAppPrincipalIdRequest
     */
    public function setReturnKeyValues($returnKeyValues = null)
    {
        if (is_null($returnKeyValues) || (is_array($returnKeyValues) && empty($returnKeyValues))) {
            unset($this->ReturnKeyValues);
        } else {
            $this->ReturnKeyValues = $returnKeyValues;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListServicePrincipalCredentialsByAppPrincipalIdRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
