<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListResults StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ListResults
 * @subpackage Structs
 */
class ListResults extends AbstractStructBase
{
    /**
     * The IsFirstPage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFirstPage;
    /**
     * The IsLastPage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLastPage;
    /**
     * The ListContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListContext;
    /**
     * Constructor method for ListResults
     * @uses ListResults::setIsFirstPage()
     * @uses ListResults::setIsLastPage()
     * @uses ListResults::setListContext()
     * @param bool $isFirstPage
     * @param bool $isLastPage
     * @param string $listContext
     */
    public function __construct($isFirstPage = null, $isLastPage = null, $listContext = null)
    {
        $this
            ->setIsFirstPage($isFirstPage)
            ->setIsLastPage($isLastPage)
            ->setListContext($listContext);
    }
    /**
     * Get IsFirstPage value
     * @return bool|null
     */
    public function getIsFirstPage()
    {
        return $this->IsFirstPage;
    }
    /**
     * Set IsFirstPage value
     * @param bool $isFirstPage
     * @return \StructType\ListResults
     */
    public function setIsFirstPage($isFirstPage = null)
    {
        $this->IsFirstPage = $isFirstPage;
        return $this;
    }
    /**
     * Get IsLastPage value
     * @return bool|null
     */
    public function getIsLastPage()
    {
        return $this->IsLastPage;
    }
    /**
     * Set IsLastPage value
     * @param bool $isLastPage
     * @return \StructType\ListResults
     */
    public function setIsLastPage($isLastPage = null)
    {
        $this->IsLastPage = $isLastPage;
        return $this;
    }
    /**
     * Get ListContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListContext()
    {
        return isset($this->ListContext) ? $this->ListContext : null;
    }
    /**
     * Set ListContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listContext
     * @return \StructType\ListResults
     */
    public function setListContext($listContext = null)
    {
        // validation for constraint: string
        if (!is_null($listContext) && !is_string($listContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listContext)), __LINE__);
        }
        if (is_null($listContext) || (is_array($listContext) && empty($listContext))) {
            unset($this->ListContext);
        } else {
            $this->ListContext = $listContext;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
