<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseOption StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LicenseOption
 * @subpackage Structs
 */
class LicenseOption extends AbstractStructBase
{
    /**
     * The AccountSkuId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountSkuIdentifier
     */
    public $AccountSkuId;
    /**
     * The DisabledServicePlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $DisabledServicePlans;
    /**
     * Constructor method for LicenseOption
     * @uses LicenseOption::setAccountSkuId()
     * @uses LicenseOption::setDisabledServicePlans()
     * @param \StructType\AccountSkuIdentifier $accountSkuId
     * @param \ArrayType\ArrayOfstring $disabledServicePlans
     */
    public function __construct(\StructType\AccountSkuIdentifier $accountSkuId = null, \ArrayType\ArrayOfstring $disabledServicePlans = null)
    {
        $this
            ->setAccountSkuId($accountSkuId)
            ->setDisabledServicePlans($disabledServicePlans);
    }
    /**
     * Get AccountSkuId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountSkuIdentifier|null
     */
    public function getAccountSkuId()
    {
        return isset($this->AccountSkuId) ? $this->AccountSkuId : null;
    }
    /**
     * Set AccountSkuId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountSkuIdentifier $accountSkuId
     * @return \StructType\LicenseOption
     */
    public function setAccountSkuId(\StructType\AccountSkuIdentifier $accountSkuId = null)
    {
        if (is_null($accountSkuId) || (is_array($accountSkuId) && empty($accountSkuId))) {
            unset($this->AccountSkuId);
        } else {
            $this->AccountSkuId = $accountSkuId;
        }
        return $this;
    }
    /**
     * Get DisabledServicePlans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDisabledServicePlans()
    {
        return isset($this->DisabledServicePlans) ? $this->DisabledServicePlans : null;
    }
    /**
     * Set DisabledServicePlans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $disabledServicePlans
     * @return \StructType\LicenseOption
     */
    public function setDisabledServicePlans(\ArrayType\ArrayOfstring $disabledServicePlans = null)
    {
        if (is_null($disabledServicePlans) || (is_array($disabledServicePlans) && empty($disabledServicePlans))) {
            unset($this->DisabledServicePlans);
        } else {
            $this->DisabledServicePlans = $disabledServicePlans;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicenseOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
