<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseAssignment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LicenseAssignment
 * @subpackage Structs
 */
class LicenseAssignment extends AbstractStructBase
{
    /**
     * The DisabledServicePlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $DisabledServicePlans;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The ReferencedObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedObjectId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for LicenseAssignment
     * @uses LicenseAssignment::setDisabledServicePlans()
     * @uses LicenseAssignment::setError()
     * @uses LicenseAssignment::setReferencedObjectId()
     * @uses LicenseAssignment::setStatus()
     * @param \ArrayType\ArrayOfstring $disabledServicePlans
     * @param string $error
     * @param string $referencedObjectId
     * @param string $status
     */
    public function __construct(\ArrayType\ArrayOfstring $disabledServicePlans = null, $error = null, $referencedObjectId = null, $status = null)
    {
        $this
            ->setDisabledServicePlans($disabledServicePlans)
            ->setError($error)
            ->setReferencedObjectId($referencedObjectId)
            ->setStatus($status);
    }
    /**
     * Get DisabledServicePlans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDisabledServicePlans()
    {
        return isset($this->DisabledServicePlans) ? $this->DisabledServicePlans : null;
    }
    /**
     * Set DisabledServicePlans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $disabledServicePlans
     * @return \StructType\LicenseAssignment
     */
    public function setDisabledServicePlans(\ArrayType\ArrayOfstring $disabledServicePlans = null)
    {
        if (is_null($disabledServicePlans) || (is_array($disabledServicePlans) && empty($disabledServicePlans))) {
            unset($this->DisabledServicePlans);
        } else {
            $this->DisabledServicePlans = $disabledServicePlans;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \StructType\LicenseAssignment
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get ReferencedObjectId value
     * @return string|null
     */
    public function getReferencedObjectId()
    {
        return $this->ReferencedObjectId;
    }
    /**
     * Set ReferencedObjectId value
     * @param string $referencedObjectId
     * @return \StructType\LicenseAssignment
     */
    public function setReferencedObjectId($referencedObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($referencedObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $referencedObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($referencedObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referencedObjectId) && !is_string($referencedObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referencedObjectId)), __LINE__);
        }
        $this->ReferencedObjectId = $referencedObjectId;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\LicenseAssignmentStatusType::valueIsValid()
     * @uses \EnumType\LicenseAssignmentStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\LicenseAssignment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LicenseAssignmentStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\LicenseAssignmentStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicenseAssignment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
