<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvalidParameterException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InvalidParameterException
 * @subpackage Structs
 */
class InvalidParameterException extends MsolAdministrationException
{
    /**
     * The ParameterName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParameterName;
    /**
     * Constructor method for InvalidParameterException
     * @uses InvalidParameterException::setParameterName()
     * @param string $parameterName
     */
    public function __construct($parameterName = null)
    {
        $this
            ->setParameterName($parameterName);
    }
    /**
     * Get ParameterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParameterName()
    {
        return isset($this->ParameterName) ? $this->ParameterName : null;
    }
    /**
     * Set ParameterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parameterName
     * @return \StructType\InvalidParameterException
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterName)), __LINE__);
        }
        if (is_null($parameterName) || (is_array($parameterName) && empty($parameterName))) {
            unset($this->ParameterName);
        } else {
            $this->ParameterName = $parameterName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvalidParameterException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
