<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetUserRequest
 * @subpackage Structs
 */
class GetUserRequest extends Request
{
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The ReturnDeletedUsers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnDeletedUsers;
    /**
     * Constructor method for GetUserRequest
     * @uses GetUserRequest::setObjectId()
     * @uses GetUserRequest::setReturnDeletedUsers()
     * @param string $objectId
     * @param bool $returnDeletedUsers
     */
    public function __construct($objectId = null, $returnDeletedUsers = null)
    {
        $this
            ->setObjectId($objectId)
            ->setReturnDeletedUsers($returnDeletedUsers);
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \StructType\GetUserRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get ReturnDeletedUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnDeletedUsers()
    {
        return isset($this->ReturnDeletedUsers) ? $this->ReturnDeletedUsers : null;
    }
    /**
     * Set ReturnDeletedUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnDeletedUsers
     * @return \StructType\GetUserRequest
     */
    public function setReturnDeletedUsers($returnDeletedUsers = null)
    {
        if (is_null($returnDeletedUsers) || (is_array($returnDeletedUsers) && empty($returnDeletedUsers))) {
            unset($this->ReturnDeletedUsers);
        } else {
            $this->ReturnDeletedUsers = $returnDeletedUsers;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
