<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDomainVerificationDnsRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetDomainVerificationDnsRequest
 * @subpackage Structs
 */
class GetDomainVerificationDnsRequest extends Request
{
    /**
     * The DomainName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainName;
    /**
     * The Mode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mode;
    /**
     * Constructor method for GetDomainVerificationDnsRequest
     * @uses GetDomainVerificationDnsRequest::setDomainName()
     * @uses GetDomainVerificationDnsRequest::setMode()
     * @param string $domainName
     * @param string $mode
     */
    public function __construct($domainName = null, $mode = null)
    {
        $this
            ->setDomainName($domainName)
            ->setMode($mode);
    }
    /**
     * Get DomainName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->DomainName) ? $this->DomainName : null;
    }
    /**
     * Set DomainName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainName
     * @return \StructType\GetDomainVerificationDnsRequest
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->DomainName);
        } else {
            $this->DomainName = $domainName;
        }
        return $this;
    }
    /**
     * Get Mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMode()
    {
        return isset($this->Mode) ? $this->Mode : null;
    }
    /**
     * Set Mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainVerificationMode::valueIsValid()
     * @uses \EnumType\DomainVerificationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \StructType\GetDomainVerificationDnsRequest
     */
    public function setMode($mode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainVerificationMode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mode, implode(', ', \EnumType\DomainVerificationMode::getValidValues())), __LINE__);
        }
        if (is_null($mode) || (is_array($mode) && empty($mode))) {
            unset($this->Mode);
        } else {
            $this->Mode = $mode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDomainVerificationDnsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
