<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainSearchFilter StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainSearchFilter
 * @subpackage Structs
 */
class DomainSearchFilter extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Authentication;
    /**
     * The Capability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Capability;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for DomainSearchFilter
     * @uses DomainSearchFilter::setAuthentication()
     * @uses DomainSearchFilter::setCapability()
     * @uses DomainSearchFilter::setStatus()
     * @param string $authentication
     * @param string $capability
     * @param string $status
     */
    public function __construct($authentication = null, $capability = null, $status = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setCapability($capability)
            ->setStatus($status);
    }
    /**
     * Get Authentication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthentication()
    {
        return isset($this->Authentication) ? $this->Authentication : null;
    }
    /**
     * Set Authentication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainAuthenticationType::valueIsValid()
     * @uses \EnumType\DomainAuthenticationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authentication
     * @return \StructType\DomainSearchFilter
     */
    public function setAuthentication($authentication = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainAuthenticationType::valueIsValid($authentication)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authentication, implode(', ', \EnumType\DomainAuthenticationType::getValidValues())), __LINE__);
        }
        if (is_null($authentication) || (is_array($authentication) && empty($authentication))) {
            unset($this->Authentication);
        } else {
            $this->Authentication = $authentication;
        }
        return $this;
    }
    /**
     * Get Capability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCapability()
    {
        return isset($this->Capability) ? $this->Capability : null;
    }
    /**
     * Set Capability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainCapabilities::valueIsValid()
     * @uses \EnumType\DomainCapabilities::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $capability
     * @return \StructType\DomainSearchFilter
     */
    public function setCapability($capability = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainCapabilities::valueIsValid($capability)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $capability, implode(', ', \EnumType\DomainCapabilities::getValidValues())), __LINE__);
        }
        if (is_null($capability) || (is_array($capability) && empty($capability))) {
            unset($this->Capability);
        } else {
            $this->Capability = $capability;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainStatus::valueIsValid()
     * @uses \EnumType\DomainStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DomainSearchFilter
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\DomainStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainSearchFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
