<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainFederationSettings StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainFederationSettings
 * @subpackage Structs
 */
class DomainFederationSettings extends AbstractStructBase
{
    /**
     * The ActiveLogOnUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveLogOnUri;
    /**
     * The DefaultInteractiveAuthenticationMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultInteractiveAuthenticationMethod;
    /**
     * The FederationBrandName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FederationBrandName;
    /**
     * The IssuerUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuerUri;
    /**
     * The LogOffUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogOffUri;
    /**
     * The MetadataExchangeUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MetadataExchangeUri;
    /**
     * The NextSigningCertificate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextSigningCertificate;
    /**
     * The OpenIdConnectDiscoveryEndpoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpenIdConnectDiscoveryEndpoint;
    /**
     * The PassiveLogOnUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassiveLogOnUri;
    /**
     * The PasswordChangeUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PasswordChangeUri;
    /**
     * The PasswordResetUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PasswordResetUri;
    /**
     * The PreferredAuthenticationProtocol
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredAuthenticationProtocol;
    /**
     * The PromptLoginBehavior
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromptLoginBehavior;
    /**
     * The SigningCertificate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SigningCertificate;
    /**
     * The SigningCertificateUpdateStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SigningCertificateUpdateStatus
     */
    public $SigningCertificateUpdateStatus;
    /**
     * The SupportsMfa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SupportsMfa;
    /**
     * Constructor method for DomainFederationSettings
     * @uses DomainFederationSettings::setActiveLogOnUri()
     * @uses DomainFederationSettings::setDefaultInteractiveAuthenticationMethod()
     * @uses DomainFederationSettings::setFederationBrandName()
     * @uses DomainFederationSettings::setIssuerUri()
     * @uses DomainFederationSettings::setLogOffUri()
     * @uses DomainFederationSettings::setMetadataExchangeUri()
     * @uses DomainFederationSettings::setNextSigningCertificate()
     * @uses DomainFederationSettings::setOpenIdConnectDiscoveryEndpoint()
     * @uses DomainFederationSettings::setPassiveLogOnUri()
     * @uses DomainFederationSettings::setPasswordChangeUri()
     * @uses DomainFederationSettings::setPasswordResetUri()
     * @uses DomainFederationSettings::setPreferredAuthenticationProtocol()
     * @uses DomainFederationSettings::setPromptLoginBehavior()
     * @uses DomainFederationSettings::setSigningCertificate()
     * @uses DomainFederationSettings::setSigningCertificateUpdateStatus()
     * @uses DomainFederationSettings::setSupportsMfa()
     * @param string $activeLogOnUri
     * @param string $defaultInteractiveAuthenticationMethod
     * @param string $federationBrandName
     * @param string $issuerUri
     * @param string $logOffUri
     * @param string $metadataExchangeUri
     * @param string $nextSigningCertificate
     * @param string $openIdConnectDiscoveryEndpoint
     * @param string $passiveLogOnUri
     * @param string $passwordChangeUri
     * @param string $passwordResetUri
     * @param string $preferredAuthenticationProtocol
     * @param string $promptLoginBehavior
     * @param string $signingCertificate
     * @param \StructType\SigningCertificateUpdateStatus $signingCertificateUpdateStatus
     * @param bool $supportsMfa
     */
    public function __construct($activeLogOnUri = null, $defaultInteractiveAuthenticationMethod = null, $federationBrandName = null, $issuerUri = null, $logOffUri = null, $metadataExchangeUri = null, $nextSigningCertificate = null, $openIdConnectDiscoveryEndpoint = null, $passiveLogOnUri = null, $passwordChangeUri = null, $passwordResetUri = null, $preferredAuthenticationProtocol = null, $promptLoginBehavior = null, $signingCertificate = null, \StructType\SigningCertificateUpdateStatus $signingCertificateUpdateStatus = null, $supportsMfa = null)
    {
        $this
            ->setActiveLogOnUri($activeLogOnUri)
            ->setDefaultInteractiveAuthenticationMethod($defaultInteractiveAuthenticationMethod)
            ->setFederationBrandName($federationBrandName)
            ->setIssuerUri($issuerUri)
            ->setLogOffUri($logOffUri)
            ->setMetadataExchangeUri($metadataExchangeUri)
            ->setNextSigningCertificate($nextSigningCertificate)
            ->setOpenIdConnectDiscoveryEndpoint($openIdConnectDiscoveryEndpoint)
            ->setPassiveLogOnUri($passiveLogOnUri)
            ->setPasswordChangeUri($passwordChangeUri)
            ->setPasswordResetUri($passwordResetUri)
            ->setPreferredAuthenticationProtocol($preferredAuthenticationProtocol)
            ->setPromptLoginBehavior($promptLoginBehavior)
            ->setSigningCertificate($signingCertificate)
            ->setSigningCertificateUpdateStatus($signingCertificateUpdateStatus)
            ->setSupportsMfa($supportsMfa);
    }
    /**
     * Get ActiveLogOnUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveLogOnUri()
    {
        return isset($this->ActiveLogOnUri) ? $this->ActiveLogOnUri : null;
    }
    /**
     * Set ActiveLogOnUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeLogOnUri
     * @return \StructType\DomainFederationSettings
     */
    public function setActiveLogOnUri($activeLogOnUri = null)
    {
        // validation for constraint: string
        if (!is_null($activeLogOnUri) && !is_string($activeLogOnUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activeLogOnUri)), __LINE__);
        }
        if (is_null($activeLogOnUri) || (is_array($activeLogOnUri) && empty($activeLogOnUri))) {
            unset($this->ActiveLogOnUri);
        } else {
            $this->ActiveLogOnUri = $activeLogOnUri;
        }
        return $this;
    }
    /**
     * Get DefaultInteractiveAuthenticationMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultInteractiveAuthenticationMethod()
    {
        return isset($this->DefaultInteractiveAuthenticationMethod) ? $this->DefaultInteractiveAuthenticationMethod : null;
    }
    /**
     * Set DefaultInteractiveAuthenticationMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultInteractiveAuthenticationMethod
     * @return \StructType\DomainFederationSettings
     */
    public function setDefaultInteractiveAuthenticationMethod($defaultInteractiveAuthenticationMethod = null)
    {
        // validation for constraint: string
        if (!is_null($defaultInteractiveAuthenticationMethod) && !is_string($defaultInteractiveAuthenticationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultInteractiveAuthenticationMethod)), __LINE__);
        }
        if (is_null($defaultInteractiveAuthenticationMethod) || (is_array($defaultInteractiveAuthenticationMethod) && empty($defaultInteractiveAuthenticationMethod))) {
            unset($this->DefaultInteractiveAuthenticationMethod);
        } else {
            $this->DefaultInteractiveAuthenticationMethod = $defaultInteractiveAuthenticationMethod;
        }
        return $this;
    }
    /**
     * Get FederationBrandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFederationBrandName()
    {
        return isset($this->FederationBrandName) ? $this->FederationBrandName : null;
    }
    /**
     * Set FederationBrandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $federationBrandName
     * @return \StructType\DomainFederationSettings
     */
    public function setFederationBrandName($federationBrandName = null)
    {
        // validation for constraint: string
        if (!is_null($federationBrandName) && !is_string($federationBrandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($federationBrandName)), __LINE__);
        }
        if (is_null($federationBrandName) || (is_array($federationBrandName) && empty($federationBrandName))) {
            unset($this->FederationBrandName);
        } else {
            $this->FederationBrandName = $federationBrandName;
        }
        return $this;
    }
    /**
     * Get IssuerUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuerUri()
    {
        return isset($this->IssuerUri) ? $this->IssuerUri : null;
    }
    /**
     * Set IssuerUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuerUri
     * @return \StructType\DomainFederationSettings
     */
    public function setIssuerUri($issuerUri = null)
    {
        // validation for constraint: string
        if (!is_null($issuerUri) && !is_string($issuerUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerUri)), __LINE__);
        }
        if (is_null($issuerUri) || (is_array($issuerUri) && empty($issuerUri))) {
            unset($this->IssuerUri);
        } else {
            $this->IssuerUri = $issuerUri;
        }
        return $this;
    }
    /**
     * Get LogOffUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogOffUri()
    {
        return isset($this->LogOffUri) ? $this->LogOffUri : null;
    }
    /**
     * Set LogOffUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logOffUri
     * @return \StructType\DomainFederationSettings
     */
    public function setLogOffUri($logOffUri = null)
    {
        // validation for constraint: string
        if (!is_null($logOffUri) && !is_string($logOffUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logOffUri)), __LINE__);
        }
        if (is_null($logOffUri) || (is_array($logOffUri) && empty($logOffUri))) {
            unset($this->LogOffUri);
        } else {
            $this->LogOffUri = $logOffUri;
        }
        return $this;
    }
    /**
     * Get MetadataExchangeUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMetadataExchangeUri()
    {
        return isset($this->MetadataExchangeUri) ? $this->MetadataExchangeUri : null;
    }
    /**
     * Set MetadataExchangeUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $metadataExchangeUri
     * @return \StructType\DomainFederationSettings
     */
    public function setMetadataExchangeUri($metadataExchangeUri = null)
    {
        // validation for constraint: string
        if (!is_null($metadataExchangeUri) && !is_string($metadataExchangeUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($metadataExchangeUri)), __LINE__);
        }
        if (is_null($metadataExchangeUri) || (is_array($metadataExchangeUri) && empty($metadataExchangeUri))) {
            unset($this->MetadataExchangeUri);
        } else {
            $this->MetadataExchangeUri = $metadataExchangeUri;
        }
        return $this;
    }
    /**
     * Get NextSigningCertificate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextSigningCertificate()
    {
        return isset($this->NextSigningCertificate) ? $this->NextSigningCertificate : null;
    }
    /**
     * Set NextSigningCertificate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextSigningCertificate
     * @return \StructType\DomainFederationSettings
     */
    public function setNextSigningCertificate($nextSigningCertificate = null)
    {
        // validation for constraint: string
        if (!is_null($nextSigningCertificate) && !is_string($nextSigningCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextSigningCertificate)), __LINE__);
        }
        if (is_null($nextSigningCertificate) || (is_array($nextSigningCertificate) && empty($nextSigningCertificate))) {
            unset($this->NextSigningCertificate);
        } else {
            $this->NextSigningCertificate = $nextSigningCertificate;
        }
        return $this;
    }
    /**
     * Get OpenIdConnectDiscoveryEndpoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenIdConnectDiscoveryEndpoint()
    {
        return isset($this->OpenIdConnectDiscoveryEndpoint) ? $this->OpenIdConnectDiscoveryEndpoint : null;
    }
    /**
     * Set OpenIdConnectDiscoveryEndpoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openIdConnectDiscoveryEndpoint
     * @return \StructType\DomainFederationSettings
     */
    public function setOpenIdConnectDiscoveryEndpoint($openIdConnectDiscoveryEndpoint = null)
    {
        // validation for constraint: string
        if (!is_null($openIdConnectDiscoveryEndpoint) && !is_string($openIdConnectDiscoveryEndpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openIdConnectDiscoveryEndpoint)), __LINE__);
        }
        if (is_null($openIdConnectDiscoveryEndpoint) || (is_array($openIdConnectDiscoveryEndpoint) && empty($openIdConnectDiscoveryEndpoint))) {
            unset($this->OpenIdConnectDiscoveryEndpoint);
        } else {
            $this->OpenIdConnectDiscoveryEndpoint = $openIdConnectDiscoveryEndpoint;
        }
        return $this;
    }
    /**
     * Get PassiveLogOnUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassiveLogOnUri()
    {
        return isset($this->PassiveLogOnUri) ? $this->PassiveLogOnUri : null;
    }
    /**
     * Set PassiveLogOnUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passiveLogOnUri
     * @return \StructType\DomainFederationSettings
     */
    public function setPassiveLogOnUri($passiveLogOnUri = null)
    {
        // validation for constraint: string
        if (!is_null($passiveLogOnUri) && !is_string($passiveLogOnUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passiveLogOnUri)), __LINE__);
        }
        if (is_null($passiveLogOnUri) || (is_array($passiveLogOnUri) && empty($passiveLogOnUri))) {
            unset($this->PassiveLogOnUri);
        } else {
            $this->PassiveLogOnUri = $passiveLogOnUri;
        }
        return $this;
    }
    /**
     * Get PasswordChangeUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPasswordChangeUri()
    {
        return isset($this->PasswordChangeUri) ? $this->PasswordChangeUri : null;
    }
    /**
     * Set PasswordChangeUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passwordChangeUri
     * @return \StructType\DomainFederationSettings
     */
    public function setPasswordChangeUri($passwordChangeUri = null)
    {
        // validation for constraint: string
        if (!is_null($passwordChangeUri) && !is_string($passwordChangeUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordChangeUri)), __LINE__);
        }
        if (is_null($passwordChangeUri) || (is_array($passwordChangeUri) && empty($passwordChangeUri))) {
            unset($this->PasswordChangeUri);
        } else {
            $this->PasswordChangeUri = $passwordChangeUri;
        }
        return $this;
    }
    /**
     * Get PasswordResetUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPasswordResetUri()
    {
        return isset($this->PasswordResetUri) ? $this->PasswordResetUri : null;
    }
    /**
     * Set PasswordResetUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passwordResetUri
     * @return \StructType\DomainFederationSettings
     */
    public function setPasswordResetUri($passwordResetUri = null)
    {
        // validation for constraint: string
        if (!is_null($passwordResetUri) && !is_string($passwordResetUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordResetUri)), __LINE__);
        }
        if (is_null($passwordResetUri) || (is_array($passwordResetUri) && empty($passwordResetUri))) {
            unset($this->PasswordResetUri);
        } else {
            $this->PasswordResetUri = $passwordResetUri;
        }
        return $this;
    }
    /**
     * Get PreferredAuthenticationProtocol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredAuthenticationProtocol()
    {
        return isset($this->PreferredAuthenticationProtocol) ? $this->PreferredAuthenticationProtocol : null;
    }
    /**
     * Set PreferredAuthenticationProtocol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AuthenticationProtocol::valueIsValid()
     * @uses \EnumType\AuthenticationProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferredAuthenticationProtocol
     * @return \StructType\DomainFederationSettings
     */
    public function setPreferredAuthenticationProtocol($preferredAuthenticationProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AuthenticationProtocol::valueIsValid($preferredAuthenticationProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferredAuthenticationProtocol, implode(', ', \EnumType\AuthenticationProtocol::getValidValues())), __LINE__);
        }
        if (is_null($preferredAuthenticationProtocol) || (is_array($preferredAuthenticationProtocol) && empty($preferredAuthenticationProtocol))) {
            unset($this->PreferredAuthenticationProtocol);
        } else {
            $this->PreferredAuthenticationProtocol = $preferredAuthenticationProtocol;
        }
        return $this;
    }
    /**
     * Get PromptLoginBehavior value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromptLoginBehavior()
    {
        return isset($this->PromptLoginBehavior) ? $this->PromptLoginBehavior : null;
    }
    /**
     * Set PromptLoginBehavior value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\PromptLoginBehavior::valueIsValid()
     * @uses \EnumType\PromptLoginBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $promptLoginBehavior
     * @return \StructType\DomainFederationSettings
     */
    public function setPromptLoginBehavior($promptLoginBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PromptLoginBehavior::valueIsValid($promptLoginBehavior)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $promptLoginBehavior, implode(', ', \EnumType\PromptLoginBehavior::getValidValues())), __LINE__);
        }
        if (is_null($promptLoginBehavior) || (is_array($promptLoginBehavior) && empty($promptLoginBehavior))) {
            unset($this->PromptLoginBehavior);
        } else {
            $this->PromptLoginBehavior = $promptLoginBehavior;
        }
        return $this;
    }
    /**
     * Get SigningCertificate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSigningCertificate()
    {
        return isset($this->SigningCertificate) ? $this->SigningCertificate : null;
    }
    /**
     * Set SigningCertificate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signingCertificate
     * @return \StructType\DomainFederationSettings
     */
    public function setSigningCertificate($signingCertificate = null)
    {
        // validation for constraint: string
        if (!is_null($signingCertificate) && !is_string($signingCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signingCertificate)), __LINE__);
        }
        if (is_null($signingCertificate) || (is_array($signingCertificate) && empty($signingCertificate))) {
            unset($this->SigningCertificate);
        } else {
            $this->SigningCertificate = $signingCertificate;
        }
        return $this;
    }
    /**
     * Get SigningCertificateUpdateStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SigningCertificateUpdateStatus|null
     */
    public function getSigningCertificateUpdateStatus()
    {
        return isset($this->SigningCertificateUpdateStatus) ? $this->SigningCertificateUpdateStatus : null;
    }
    /**
     * Set SigningCertificateUpdateStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SigningCertificateUpdateStatus $signingCertificateUpdateStatus
     * @return \StructType\DomainFederationSettings
     */
    public function setSigningCertificateUpdateStatus(\StructType\SigningCertificateUpdateStatus $signingCertificateUpdateStatus = null)
    {
        if (is_null($signingCertificateUpdateStatus) || (is_array($signingCertificateUpdateStatus) && empty($signingCertificateUpdateStatus))) {
            unset($this->SigningCertificateUpdateStatus);
        } else {
            $this->SigningCertificateUpdateStatus = $signingCertificateUpdateStatus;
        }
        return $this;
    }
    /**
     * Get SupportsMfa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSupportsMfa()
    {
        return isset($this->SupportsMfa) ? $this->SupportsMfa : null;
    }
    /**
     * Set SupportsMfa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $supportsMfa
     * @return \StructType\DomainFederationSettings
     */
    public function setSupportsMfa($supportsMfa = null)
    {
        if (is_null($supportsMfa) || (is_array($supportsMfa) && empty($supportsMfa))) {
            unset($this->SupportsMfa);
        } else {
            $this->SupportsMfa = $supportsMfa;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainFederationSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
