<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainDataOperationException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainDataOperationException
 * @subpackage Structs
 */
class DomainDataOperationException extends DataOperationException
{
    /**
     * The DomainName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainName;
    /**
     * The ParameterName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParameterName;
    /**
     * The ParameterValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParameterValue;
    /**
     * Constructor method for DomainDataOperationException
     * @uses DomainDataOperationException::setDomainName()
     * @uses DomainDataOperationException::setParameterName()
     * @uses DomainDataOperationException::setParameterValue()
     * @param string $domainName
     * @param string $parameterName
     * @param string $parameterValue
     */
    public function __construct($domainName = null, $parameterName = null, $parameterValue = null)
    {
        $this
            ->setDomainName($domainName)
            ->setParameterName($parameterName)
            ->setParameterValue($parameterValue);
    }
    /**
     * Get DomainName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->DomainName) ? $this->DomainName : null;
    }
    /**
     * Set DomainName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainName
     * @return \StructType\DomainDataOperationException
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->DomainName);
        } else {
            $this->DomainName = $domainName;
        }
        return $this;
    }
    /**
     * Get ParameterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParameterName()
    {
        return isset($this->ParameterName) ? $this->ParameterName : null;
    }
    /**
     * Set ParameterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parameterName
     * @return \StructType\DomainDataOperationException
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterName)), __LINE__);
        }
        if (is_null($parameterName) || (is_array($parameterName) && empty($parameterName))) {
            unset($this->ParameterName);
        } else {
            $this->ParameterName = $parameterName;
        }
        return $this;
    }
    /**
     * Get ParameterValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParameterValue()
    {
        return isset($this->ParameterValue) ? $this->ParameterValue : null;
    }
    /**
     * Set ParameterValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parameterValue
     * @return \StructType\DomainDataOperationException
     */
    public function setParameterValue($parameterValue = null)
    {
        // validation for constraint: string
        if (!is_null($parameterValue) && !is_string($parameterValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterValue)), __LINE__);
        }
        if (is_null($parameterValue) || (is_array($parameterValue) && empty($parameterValue))) {
            unset($this->ParameterValue);
        } else {
            $this->ParameterValue = $parameterValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainDataOperationException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
