<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Domain StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Domain
 * @subpackage Structs
 */
class Domain extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Authentication;
    /**
     * The Capabilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Capabilities;
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefault;
    /**
     * The IsInitial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInitial;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The RootDomain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RootDomain;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The VerificationMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VerificationMethod;
    /**
     * Constructor method for Domain
     * @uses Domain::setAuthentication()
     * @uses Domain::setCapabilities()
     * @uses Domain::setIsDefault()
     * @uses Domain::setIsInitial()
     * @uses Domain::setName()
     * @uses Domain::setRootDomain()
     * @uses Domain::setStatus()
     * @uses Domain::setVerificationMethod()
     * @param string $authentication
     * @param string $capabilities
     * @param bool $isDefault
     * @param bool $isInitial
     * @param string $name
     * @param string $rootDomain
     * @param string $status
     * @param string $verificationMethod
     */
    public function __construct($authentication = null, $capabilities = null, $isDefault = null, $isInitial = null, $name = null, $rootDomain = null, $status = null, $verificationMethod = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setCapabilities($capabilities)
            ->setIsDefault($isDefault)
            ->setIsInitial($isInitial)
            ->setName($name)
            ->setRootDomain($rootDomain)
            ->setStatus($status)
            ->setVerificationMethod($verificationMethod);
    }
    /**
     * Get Authentication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthentication()
    {
        return isset($this->Authentication) ? $this->Authentication : null;
    }
    /**
     * Set Authentication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainAuthenticationType::valueIsValid()
     * @uses \EnumType\DomainAuthenticationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authentication
     * @return \StructType\Domain
     */
    public function setAuthentication($authentication = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainAuthenticationType::valueIsValid($authentication)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authentication, implode(', ', \EnumType\DomainAuthenticationType::getValidValues())), __LINE__);
        }
        if (is_null($authentication) || (is_array($authentication) && empty($authentication))) {
            unset($this->Authentication);
        } else {
            $this->Authentication = $authentication;
        }
        return $this;
    }
    /**
     * Get Capabilities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCapabilities()
    {
        return isset($this->Capabilities) ? $this->Capabilities : null;
    }
    /**
     * Set Capabilities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainCapabilities::valueIsValid()
     * @uses \EnumType\DomainCapabilities::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $capabilities
     * @return \StructType\Domain
     */
    public function setCapabilities($capabilities = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainCapabilities::valueIsValid($capabilities)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $capabilities, implode(', ', \EnumType\DomainCapabilities::getValidValues())), __LINE__);
        }
        if (is_null($capabilities) || (is_array($capabilities) && empty($capabilities))) {
            unset($this->Capabilities);
        } else {
            $this->Capabilities = $capabilities;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefault
     * @return \StructType\Domain
     */
    public function setIsDefault($isDefault = null)
    {
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get IsInitial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInitial()
    {
        return isset($this->IsInitial) ? $this->IsInitial : null;
    }
    /**
     * Set IsInitial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInitial
     * @return \StructType\Domain
     */
    public function setIsInitial($isInitial = null)
    {
        if (is_null($isInitial) || (is_array($isInitial) && empty($isInitial))) {
            unset($this->IsInitial);
        } else {
            $this->IsInitial = $isInitial;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Domain
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RootDomain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRootDomain()
    {
        return isset($this->RootDomain) ? $this->RootDomain : null;
    }
    /**
     * Set RootDomain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rootDomain
     * @return \StructType\Domain
     */
    public function setRootDomain($rootDomain = null)
    {
        // validation for constraint: string
        if (!is_null($rootDomain) && !is_string($rootDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rootDomain)), __LINE__);
        }
        if (is_null($rootDomain) || (is_array($rootDomain) && empty($rootDomain))) {
            unset($this->RootDomain);
        } else {
            $this->RootDomain = $rootDomain;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainStatus::valueIsValid()
     * @uses \EnumType\DomainStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Domain
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\DomainStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get VerificationMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerificationMethod()
    {
        return isset($this->VerificationMethod) ? $this->VerificationMethod : null;
    }
    /**
     * Set VerificationMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainVerificationMethod::valueIsValid()
     * @uses \EnumType\DomainVerificationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $verificationMethod
     * @return \StructType\Domain
     */
    public function setVerificationMethod($verificationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainVerificationMethod::valueIsValid($verificationMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $verificationMethod, implode(', ', \EnumType\DomainVerificationMethod::getValidValues())), __LINE__);
        }
        if (is_null($verificationMethod) || (is_array($verificationMethod) && empty($verificationMethod))) {
            unset($this->VerificationMethod);
        } else {
            $this->VerificationMethod = $verificationMethod;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Domain
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
