<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CompanyInformation
 * @subpackage Structs
 */
class CompanyInformation extends AbstractStructBase
{
    /**
     * The AllowAdHocSubscriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowAdHocSubscriptions;
    /**
     * The AllowEmailVerifiedUsers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowEmailVerifiedUsers;
    /**
     * The AuthorizedServiceInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $AuthorizedServiceInstances;
    /**
     * The AuthorizedServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAuthorizedService
     */
    public $AuthorizedServices;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The CompanyDeletionStartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyDeletionStartTime;
    /**
     * The CompanyTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $CompanyTags;
    /**
     * The CompanyType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CompanyType;
    /**
     * The CompassEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CompassEnabled;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The CountryLetterCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryLetterCode;
    /**
     * The DapEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DapEnabled;
    /**
     * The DefaultUsageLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultUsageLocation;
    /**
     * The DirSyncApplicationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirSyncApplicationType;
    /**
     * The DirSyncClientMachineName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirSyncClientMachineName;
    /**
     * The DirSyncClientVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirSyncClientVersion;
    /**
     * The DirSyncServiceAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirSyncServiceAccount;
    /**
     * The DirectorySynchronizationEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DirectorySynchronizationEnabled;
    /**
     * The DirectorySynchronizationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DirectorySynchronizationStatus;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The InitialDomain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InitialDomain;
    /**
     * The LastDirSyncTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDirSyncTime;
    /**
     * The LastPasswordSyncTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastPasswordSyncTime;
    /**
     * The MarketingNotificationEmails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $MarketingNotificationEmails;
    /**
     * The MultipleDataLocationsForServicesEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MultipleDataLocationsForServicesEnabled;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The PasswordSynchronizationEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PasswordSynchronizationEnabled;
    /**
     * The PortalSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PortalSettings
     */
    public $PortalSettings;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The PreferredLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredLanguage;
    /**
     * The ReleaseTrack
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReleaseTrack;
    /**
     * The ReplicationScope
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReplicationScope;
    /**
     * The RmsViralSignUpEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RmsViralSignUpEnabled;
    /**
     * The SecurityComplianceNotificationEmails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $SecurityComplianceNotificationEmails;
    /**
     * The SecurityComplianceNotificationPhones
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $SecurityComplianceNotificationPhones;
    /**
     * The SelfServePasswordResetEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SelfServePasswordResetEnabled;
    /**
     * The ServiceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceInformation
     */
    public $ServiceInformation;
    /**
     * The ServiceInstanceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceInstanceInformation
     */
    public $ServiceInstanceInformation;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The SubscriptionProvisioningLimited
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SubscriptionProvisioningLimited;
    /**
     * The TechnicalNotificationEmails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $TechnicalNotificationEmails;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TelephoneNumber;
    /**
     * The UIExtensibilityUris
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $UIExtensibilityUris;
    /**
     * The UsersPermissionToCreateGroupsEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsersPermissionToCreateGroupsEnabled;
    /**
     * The UsersPermissionToCreateLOBAppsEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsersPermissionToCreateLOBAppsEnabled;
    /**
     * The UsersPermissionToReadOtherUsersEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsersPermissionToReadOtherUsersEnabled;
    /**
     * The UsersPermissionToUserConsentToAppEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsersPermissionToUserConsentToAppEnabled;
    /**
     * Constructor method for CompanyInformation
     * @uses CompanyInformation::setAllowAdHocSubscriptions()
     * @uses CompanyInformation::setAllowEmailVerifiedUsers()
     * @uses CompanyInformation::setAuthorizedServiceInstances()
     * @uses CompanyInformation::setAuthorizedServices()
     * @uses CompanyInformation::setCity()
     * @uses CompanyInformation::setCompanyDeletionStartTime()
     * @uses CompanyInformation::setCompanyTags()
     * @uses CompanyInformation::setCompanyType()
     * @uses CompanyInformation::setCompassEnabled()
     * @uses CompanyInformation::setCountry()
     * @uses CompanyInformation::setCountryLetterCode()
     * @uses CompanyInformation::setDapEnabled()
     * @uses CompanyInformation::setDefaultUsageLocation()
     * @uses CompanyInformation::setDirSyncApplicationType()
     * @uses CompanyInformation::setDirSyncClientMachineName()
     * @uses CompanyInformation::setDirSyncClientVersion()
     * @uses CompanyInformation::setDirSyncServiceAccount()
     * @uses CompanyInformation::setDirectorySynchronizationEnabled()
     * @uses CompanyInformation::setDirectorySynchronizationStatus()
     * @uses CompanyInformation::setDisplayName()
     * @uses CompanyInformation::setInitialDomain()
     * @uses CompanyInformation::setLastDirSyncTime()
     * @uses CompanyInformation::setLastPasswordSyncTime()
     * @uses CompanyInformation::setMarketingNotificationEmails()
     * @uses CompanyInformation::setMultipleDataLocationsForServicesEnabled()
     * @uses CompanyInformation::setObjectId()
     * @uses CompanyInformation::setPasswordSynchronizationEnabled()
     * @uses CompanyInformation::setPortalSettings()
     * @uses CompanyInformation::setPostalCode()
     * @uses CompanyInformation::setPreferredLanguage()
     * @uses CompanyInformation::setReleaseTrack()
     * @uses CompanyInformation::setReplicationScope()
     * @uses CompanyInformation::setRmsViralSignUpEnabled()
     * @uses CompanyInformation::setSecurityComplianceNotificationEmails()
     * @uses CompanyInformation::setSecurityComplianceNotificationPhones()
     * @uses CompanyInformation::setSelfServePasswordResetEnabled()
     * @uses CompanyInformation::setServiceInformation()
     * @uses CompanyInformation::setServiceInstanceInformation()
     * @uses CompanyInformation::setState()
     * @uses CompanyInformation::setStreet()
     * @uses CompanyInformation::setSubscriptionProvisioningLimited()
     * @uses CompanyInformation::setTechnicalNotificationEmails()
     * @uses CompanyInformation::setTelephoneNumber()
     * @uses CompanyInformation::setUIExtensibilityUris()
     * @uses CompanyInformation::setUsersPermissionToCreateGroupsEnabled()
     * @uses CompanyInformation::setUsersPermissionToCreateLOBAppsEnabled()
     * @uses CompanyInformation::setUsersPermissionToReadOtherUsersEnabled()
     * @uses CompanyInformation::setUsersPermissionToUserConsentToAppEnabled()
     * @param bool $allowAdHocSubscriptions
     * @param bool $allowEmailVerifiedUsers
     * @param \ArrayType\ArrayOfstring $authorizedServiceInstances
     * @param \ArrayType\ArrayOfAuthorizedService $authorizedServices
     * @param string $city
     * @param string $companyDeletionStartTime
     * @param \ArrayType\ArrayOfstring $companyTags
     * @param string $companyType
     * @param bool $compassEnabled
     * @param string $country
     * @param string $countryLetterCode
     * @param bool $dapEnabled
     * @param string $defaultUsageLocation
     * @param string $dirSyncApplicationType
     * @param string $dirSyncClientMachineName
     * @param string $dirSyncClientVersion
     * @param string $dirSyncServiceAccount
     * @param bool $directorySynchronizationEnabled
     * @param string $directorySynchronizationStatus
     * @param string $displayName
     * @param string $initialDomain
     * @param string $lastDirSyncTime
     * @param string $lastPasswordSyncTime
     * @param \ArrayType\ArrayOfstring $marketingNotificationEmails
     * @param bool $multipleDataLocationsForServicesEnabled
     * @param string $objectId
     * @param bool $passwordSynchronizationEnabled
     * @param \StructType\PortalSettings $portalSettings
     * @param string $postalCode
     * @param string $preferredLanguage
     * @param string $releaseTrack
     * @param string $replicationScope
     * @param bool $rmsViralSignUpEnabled
     * @param \ArrayType\ArrayOfstring $securityComplianceNotificationEmails
     * @param \ArrayType\ArrayOfstring $securityComplianceNotificationPhones
     * @param bool $selfServePasswordResetEnabled
     * @param \ArrayType\ArrayOfServiceInformation $serviceInformation
     * @param \ArrayType\ArrayOfServiceInstanceInformation $serviceInstanceInformation
     * @param string $state
     * @param string $street
     * @param bool $subscriptionProvisioningLimited
     * @param \ArrayType\ArrayOfstring $technicalNotificationEmails
     * @param string $telephoneNumber
     * @param \ArrayType\ArrayOfKeyValueOfstringstring $uIExtensibilityUris
     * @param bool $usersPermissionToCreateGroupsEnabled
     * @param bool $usersPermissionToCreateLOBAppsEnabled
     * @param bool $usersPermissionToReadOtherUsersEnabled
     * @param bool $usersPermissionToUserConsentToAppEnabled
     */
    public function __construct($allowAdHocSubscriptions = null, $allowEmailVerifiedUsers = null, \ArrayType\ArrayOfstring $authorizedServiceInstances = null, \ArrayType\ArrayOfAuthorizedService $authorizedServices = null, $city = null, $companyDeletionStartTime = null, \ArrayType\ArrayOfstring $companyTags = null, $companyType = null, $compassEnabled = null, $country = null, $countryLetterCode = null, $dapEnabled = null, $defaultUsageLocation = null, $dirSyncApplicationType = null, $dirSyncClientMachineName = null, $dirSyncClientVersion = null, $dirSyncServiceAccount = null, $directorySynchronizationEnabled = null, $directorySynchronizationStatus = null, $displayName = null, $initialDomain = null, $lastDirSyncTime = null, $lastPasswordSyncTime = null, \ArrayType\ArrayOfstring $marketingNotificationEmails = null, $multipleDataLocationsForServicesEnabled = null, $objectId = null, $passwordSynchronizationEnabled = null, \StructType\PortalSettings $portalSettings = null, $postalCode = null, $preferredLanguage = null, $releaseTrack = null, $replicationScope = null, $rmsViralSignUpEnabled = null, \ArrayType\ArrayOfstring $securityComplianceNotificationEmails = null, \ArrayType\ArrayOfstring $securityComplianceNotificationPhones = null, $selfServePasswordResetEnabled = null, \ArrayType\ArrayOfServiceInformation $serviceInformation = null, \ArrayType\ArrayOfServiceInstanceInformation $serviceInstanceInformation = null, $state = null, $street = null, $subscriptionProvisioningLimited = null, \ArrayType\ArrayOfstring $technicalNotificationEmails = null, $telephoneNumber = null, \ArrayType\ArrayOfKeyValueOfstringstring $uIExtensibilityUris = null, $usersPermissionToCreateGroupsEnabled = null, $usersPermissionToCreateLOBAppsEnabled = null, $usersPermissionToReadOtherUsersEnabled = null, $usersPermissionToUserConsentToAppEnabled = null)
    {
        $this
            ->setAllowAdHocSubscriptions($allowAdHocSubscriptions)
            ->setAllowEmailVerifiedUsers($allowEmailVerifiedUsers)
            ->setAuthorizedServiceInstances($authorizedServiceInstances)
            ->setAuthorizedServices($authorizedServices)
            ->setCity($city)
            ->setCompanyDeletionStartTime($companyDeletionStartTime)
            ->setCompanyTags($companyTags)
            ->setCompanyType($companyType)
            ->setCompassEnabled($compassEnabled)
            ->setCountry($country)
            ->setCountryLetterCode($countryLetterCode)
            ->setDapEnabled($dapEnabled)
            ->setDefaultUsageLocation($defaultUsageLocation)
            ->setDirSyncApplicationType($dirSyncApplicationType)
            ->setDirSyncClientMachineName($dirSyncClientMachineName)
            ->setDirSyncClientVersion($dirSyncClientVersion)
            ->setDirSyncServiceAccount($dirSyncServiceAccount)
            ->setDirectorySynchronizationEnabled($directorySynchronizationEnabled)
            ->setDirectorySynchronizationStatus($directorySynchronizationStatus)
            ->setDisplayName($displayName)
            ->setInitialDomain($initialDomain)
            ->setLastDirSyncTime($lastDirSyncTime)
            ->setLastPasswordSyncTime($lastPasswordSyncTime)
            ->setMarketingNotificationEmails($marketingNotificationEmails)
            ->setMultipleDataLocationsForServicesEnabled($multipleDataLocationsForServicesEnabled)
            ->setObjectId($objectId)
            ->setPasswordSynchronizationEnabled($passwordSynchronizationEnabled)
            ->setPortalSettings($portalSettings)
            ->setPostalCode($postalCode)
            ->setPreferredLanguage($preferredLanguage)
            ->setReleaseTrack($releaseTrack)
            ->setReplicationScope($replicationScope)
            ->setRmsViralSignUpEnabled($rmsViralSignUpEnabled)
            ->setSecurityComplianceNotificationEmails($securityComplianceNotificationEmails)
            ->setSecurityComplianceNotificationPhones($securityComplianceNotificationPhones)
            ->setSelfServePasswordResetEnabled($selfServePasswordResetEnabled)
            ->setServiceInformation($serviceInformation)
            ->setServiceInstanceInformation($serviceInstanceInformation)
            ->setState($state)
            ->setStreet($street)
            ->setSubscriptionProvisioningLimited($subscriptionProvisioningLimited)
            ->setTechnicalNotificationEmails($technicalNotificationEmails)
            ->setTelephoneNumber($telephoneNumber)
            ->setUIExtensibilityUris($uIExtensibilityUris)
            ->setUsersPermissionToCreateGroupsEnabled($usersPermissionToCreateGroupsEnabled)
            ->setUsersPermissionToCreateLOBAppsEnabled($usersPermissionToCreateLOBAppsEnabled)
            ->setUsersPermissionToReadOtherUsersEnabled($usersPermissionToReadOtherUsersEnabled)
            ->setUsersPermissionToUserConsentToAppEnabled($usersPermissionToUserConsentToAppEnabled);
    }
    /**
     * Get AllowAdHocSubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowAdHocSubscriptions()
    {
        return isset($this->AllowAdHocSubscriptions) ? $this->AllowAdHocSubscriptions : null;
    }
    /**
     * Set AllowAdHocSubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowAdHocSubscriptions
     * @return \StructType\CompanyInformation
     */
    public function setAllowAdHocSubscriptions($allowAdHocSubscriptions = null)
    {
        if (is_null($allowAdHocSubscriptions) || (is_array($allowAdHocSubscriptions) && empty($allowAdHocSubscriptions))) {
            unset($this->AllowAdHocSubscriptions);
        } else {
            $this->AllowAdHocSubscriptions = $allowAdHocSubscriptions;
        }
        return $this;
    }
    /**
     * Get AllowEmailVerifiedUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowEmailVerifiedUsers()
    {
        return isset($this->AllowEmailVerifiedUsers) ? $this->AllowEmailVerifiedUsers : null;
    }
    /**
     * Set AllowEmailVerifiedUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowEmailVerifiedUsers
     * @return \StructType\CompanyInformation
     */
    public function setAllowEmailVerifiedUsers($allowEmailVerifiedUsers = null)
    {
        if (is_null($allowEmailVerifiedUsers) || (is_array($allowEmailVerifiedUsers) && empty($allowEmailVerifiedUsers))) {
            unset($this->AllowEmailVerifiedUsers);
        } else {
            $this->AllowEmailVerifiedUsers = $allowEmailVerifiedUsers;
        }
        return $this;
    }
    /**
     * Get AuthorizedServiceInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getAuthorizedServiceInstances()
    {
        return isset($this->AuthorizedServiceInstances) ? $this->AuthorizedServiceInstances : null;
    }
    /**
     * Set AuthorizedServiceInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $authorizedServiceInstances
     * @return \StructType\CompanyInformation
     */
    public function setAuthorizedServiceInstances(\ArrayType\ArrayOfstring $authorizedServiceInstances = null)
    {
        if (is_null($authorizedServiceInstances) || (is_array($authorizedServiceInstances) && empty($authorizedServiceInstances))) {
            unset($this->AuthorizedServiceInstances);
        } else {
            $this->AuthorizedServiceInstances = $authorizedServiceInstances;
        }
        return $this;
    }
    /**
     * Get AuthorizedServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAuthorizedService|null
     */
    public function getAuthorizedServices()
    {
        return isset($this->AuthorizedServices) ? $this->AuthorizedServices : null;
    }
    /**
     * Set AuthorizedServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAuthorizedService $authorizedServices
     * @return \StructType\CompanyInformation
     */
    public function setAuthorizedServices(\ArrayType\ArrayOfAuthorizedService $authorizedServices = null)
    {
        if (is_null($authorizedServices) || (is_array($authorizedServices) && empty($authorizedServices))) {
            unset($this->AuthorizedServices);
        } else {
            $this->AuthorizedServices = $authorizedServices;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\CompanyInformation
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CompanyDeletionStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyDeletionStartTime()
    {
        return isset($this->CompanyDeletionStartTime) ? $this->CompanyDeletionStartTime : null;
    }
    /**
     * Set CompanyDeletionStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyDeletionStartTime
     * @return \StructType\CompanyInformation
     */
    public function setCompanyDeletionStartTime($companyDeletionStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($companyDeletionStartTime) && !is_string($companyDeletionStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyDeletionStartTime)), __LINE__);
        }
        if (is_null($companyDeletionStartTime) || (is_array($companyDeletionStartTime) && empty($companyDeletionStartTime))) {
            unset($this->CompanyDeletionStartTime);
        } else {
            $this->CompanyDeletionStartTime = $companyDeletionStartTime;
        }
        return $this;
    }
    /**
     * Get CompanyTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getCompanyTags()
    {
        return isset($this->CompanyTags) ? $this->CompanyTags : null;
    }
    /**
     * Set CompanyTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $companyTags
     * @return \StructType\CompanyInformation
     */
    public function setCompanyTags(\ArrayType\ArrayOfstring $companyTags = null)
    {
        if (is_null($companyTags) || (is_array($companyTags) && empty($companyTags))) {
            unset($this->CompanyTags);
        } else {
            $this->CompanyTags = $companyTags;
        }
        return $this;
    }
    /**
     * Get CompanyType value
     * @return string|null
     */
    public function getCompanyType()
    {
        return $this->CompanyType;
    }
    /**
     * Set CompanyType value
     * @uses \EnumType\CompanyType::valueIsValid()
     * @uses \EnumType\CompanyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $companyType
     * @return \StructType\CompanyInformation
     */
    public function setCompanyType($companyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CompanyType::valueIsValid($companyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $companyType, implode(', ', \EnumType\CompanyType::getValidValues())), __LINE__);
        }
        $this->CompanyType = $companyType;
        return $this;
    }
    /**
     * Get CompassEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCompassEnabled()
    {
        return isset($this->CompassEnabled) ? $this->CompassEnabled : null;
    }
    /**
     * Set CompassEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $compassEnabled
     * @return \StructType\CompanyInformation
     */
    public function setCompassEnabled($compassEnabled = null)
    {
        if (is_null($compassEnabled) || (is_array($compassEnabled) && empty($compassEnabled))) {
            unset($this->CompassEnabled);
        } else {
            $this->CompassEnabled = $compassEnabled;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\CompanyInformation
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get CountryLetterCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryLetterCode()
    {
        return isset($this->CountryLetterCode) ? $this->CountryLetterCode : null;
    }
    /**
     * Set CountryLetterCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryLetterCode
     * @return \StructType\CompanyInformation
     */
    public function setCountryLetterCode($countryLetterCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryLetterCode) && !is_string($countryLetterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryLetterCode)), __LINE__);
        }
        if (is_null($countryLetterCode) || (is_array($countryLetterCode) && empty($countryLetterCode))) {
            unset($this->CountryLetterCode);
        } else {
            $this->CountryLetterCode = $countryLetterCode;
        }
        return $this;
    }
    /**
     * Get DapEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDapEnabled()
    {
        return isset($this->DapEnabled) ? $this->DapEnabled : null;
    }
    /**
     * Set DapEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dapEnabled
     * @return \StructType\CompanyInformation
     */
    public function setDapEnabled($dapEnabled = null)
    {
        if (is_null($dapEnabled) || (is_array($dapEnabled) && empty($dapEnabled))) {
            unset($this->DapEnabled);
        } else {
            $this->DapEnabled = $dapEnabled;
        }
        return $this;
    }
    /**
     * Get DefaultUsageLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultUsageLocation()
    {
        return isset($this->DefaultUsageLocation) ? $this->DefaultUsageLocation : null;
    }
    /**
     * Set DefaultUsageLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultUsageLocation
     * @return \StructType\CompanyInformation
     */
    public function setDefaultUsageLocation($defaultUsageLocation = null)
    {
        // validation for constraint: string
        if (!is_null($defaultUsageLocation) && !is_string($defaultUsageLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultUsageLocation)), __LINE__);
        }
        if (is_null($defaultUsageLocation) || (is_array($defaultUsageLocation) && empty($defaultUsageLocation))) {
            unset($this->DefaultUsageLocation);
        } else {
            $this->DefaultUsageLocation = $defaultUsageLocation;
        }
        return $this;
    }
    /**
     * Get DirSyncApplicationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirSyncApplicationType()
    {
        return isset($this->DirSyncApplicationType) ? $this->DirSyncApplicationType : null;
    }
    /**
     * Set DirSyncApplicationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dirSyncApplicationType
     * @return \StructType\CompanyInformation
     */
    public function setDirSyncApplicationType($dirSyncApplicationType = null)
    {
        // validation for constraint: string
        if (!is_null($dirSyncApplicationType) && !is_string($dirSyncApplicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirSyncApplicationType)), __LINE__);
        }
        if (is_null($dirSyncApplicationType) || (is_array($dirSyncApplicationType) && empty($dirSyncApplicationType))) {
            unset($this->DirSyncApplicationType);
        } else {
            $this->DirSyncApplicationType = $dirSyncApplicationType;
        }
        return $this;
    }
    /**
     * Get DirSyncClientMachineName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirSyncClientMachineName()
    {
        return isset($this->DirSyncClientMachineName) ? $this->DirSyncClientMachineName : null;
    }
    /**
     * Set DirSyncClientMachineName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dirSyncClientMachineName
     * @return \StructType\CompanyInformation
     */
    public function setDirSyncClientMachineName($dirSyncClientMachineName = null)
    {
        // validation for constraint: string
        if (!is_null($dirSyncClientMachineName) && !is_string($dirSyncClientMachineName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirSyncClientMachineName)), __LINE__);
        }
        if (is_null($dirSyncClientMachineName) || (is_array($dirSyncClientMachineName) && empty($dirSyncClientMachineName))) {
            unset($this->DirSyncClientMachineName);
        } else {
            $this->DirSyncClientMachineName = $dirSyncClientMachineName;
        }
        return $this;
    }
    /**
     * Get DirSyncClientVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirSyncClientVersion()
    {
        return isset($this->DirSyncClientVersion) ? $this->DirSyncClientVersion : null;
    }
    /**
     * Set DirSyncClientVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dirSyncClientVersion
     * @return \StructType\CompanyInformation
     */
    public function setDirSyncClientVersion($dirSyncClientVersion = null)
    {
        // validation for constraint: string
        if (!is_null($dirSyncClientVersion) && !is_string($dirSyncClientVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirSyncClientVersion)), __LINE__);
        }
        if (is_null($dirSyncClientVersion) || (is_array($dirSyncClientVersion) && empty($dirSyncClientVersion))) {
            unset($this->DirSyncClientVersion);
        } else {
            $this->DirSyncClientVersion = $dirSyncClientVersion;
        }
        return $this;
    }
    /**
     * Get DirSyncServiceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirSyncServiceAccount()
    {
        return isset($this->DirSyncServiceAccount) ? $this->DirSyncServiceAccount : null;
    }
    /**
     * Set DirSyncServiceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dirSyncServiceAccount
     * @return \StructType\CompanyInformation
     */
    public function setDirSyncServiceAccount($dirSyncServiceAccount = null)
    {
        // validation for constraint: string
        if (!is_null($dirSyncServiceAccount) && !is_string($dirSyncServiceAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirSyncServiceAccount)), __LINE__);
        }
        if (is_null($dirSyncServiceAccount) || (is_array($dirSyncServiceAccount) && empty($dirSyncServiceAccount))) {
            unset($this->DirSyncServiceAccount);
        } else {
            $this->DirSyncServiceAccount = $dirSyncServiceAccount;
        }
        return $this;
    }
    /**
     * Get DirectorySynchronizationEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDirectorySynchronizationEnabled()
    {
        return isset($this->DirectorySynchronizationEnabled) ? $this->DirectorySynchronizationEnabled : null;
    }
    /**
     * Set DirectorySynchronizationEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $directorySynchronizationEnabled
     * @return \StructType\CompanyInformation
     */
    public function setDirectorySynchronizationEnabled($directorySynchronizationEnabled = null)
    {
        if (is_null($directorySynchronizationEnabled) || (is_array($directorySynchronizationEnabled) && empty($directorySynchronizationEnabled))) {
            unset($this->DirectorySynchronizationEnabled);
        } else {
            $this->DirectorySynchronizationEnabled = $directorySynchronizationEnabled;
        }
        return $this;
    }
    /**
     * Get DirectorySynchronizationStatus value
     * @return string|null
     */
    public function getDirectorySynchronizationStatus()
    {
        return $this->DirectorySynchronizationStatus;
    }
    /**
     * Set DirectorySynchronizationStatus value
     * @uses \EnumType\DirSyncStatus::valueIsValid()
     * @uses \EnumType\DirSyncStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directorySynchronizationStatus
     * @return \StructType\CompanyInformation
     */
    public function setDirectorySynchronizationStatus($directorySynchronizationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DirSyncStatus::valueIsValid($directorySynchronizationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $directorySynchronizationStatus, implode(', ', \EnumType\DirSyncStatus::getValidValues())), __LINE__);
        }
        $this->DirectorySynchronizationStatus = $directorySynchronizationStatus;
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\CompanyInformation
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get InitialDomain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitialDomain()
    {
        return isset($this->InitialDomain) ? $this->InitialDomain : null;
    }
    /**
     * Set InitialDomain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initialDomain
     * @return \StructType\CompanyInformation
     */
    public function setInitialDomain($initialDomain = null)
    {
        // validation for constraint: string
        if (!is_null($initialDomain) && !is_string($initialDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initialDomain)), __LINE__);
        }
        if (is_null($initialDomain) || (is_array($initialDomain) && empty($initialDomain))) {
            unset($this->InitialDomain);
        } else {
            $this->InitialDomain = $initialDomain;
        }
        return $this;
    }
    /**
     * Get LastDirSyncTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDirSyncTime()
    {
        return isset($this->LastDirSyncTime) ? $this->LastDirSyncTime : null;
    }
    /**
     * Set LastDirSyncTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDirSyncTime
     * @return \StructType\CompanyInformation
     */
    public function setLastDirSyncTime($lastDirSyncTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDirSyncTime) && !is_string($lastDirSyncTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDirSyncTime)), __LINE__);
        }
        if (is_null($lastDirSyncTime) || (is_array($lastDirSyncTime) && empty($lastDirSyncTime))) {
            unset($this->LastDirSyncTime);
        } else {
            $this->LastDirSyncTime = $lastDirSyncTime;
        }
        return $this;
    }
    /**
     * Get LastPasswordSyncTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastPasswordSyncTime()
    {
        return isset($this->LastPasswordSyncTime) ? $this->LastPasswordSyncTime : null;
    }
    /**
     * Set LastPasswordSyncTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastPasswordSyncTime
     * @return \StructType\CompanyInformation
     */
    public function setLastPasswordSyncTime($lastPasswordSyncTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastPasswordSyncTime) && !is_string($lastPasswordSyncTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastPasswordSyncTime)), __LINE__);
        }
        if (is_null($lastPasswordSyncTime) || (is_array($lastPasswordSyncTime) && empty($lastPasswordSyncTime))) {
            unset($this->LastPasswordSyncTime);
        } else {
            $this->LastPasswordSyncTime = $lastPasswordSyncTime;
        }
        return $this;
    }
    /**
     * Get MarketingNotificationEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getMarketingNotificationEmails()
    {
        return isset($this->MarketingNotificationEmails) ? $this->MarketingNotificationEmails : null;
    }
    /**
     * Set MarketingNotificationEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $marketingNotificationEmails
     * @return \StructType\CompanyInformation
     */
    public function setMarketingNotificationEmails(\ArrayType\ArrayOfstring $marketingNotificationEmails = null)
    {
        if (is_null($marketingNotificationEmails) || (is_array($marketingNotificationEmails) && empty($marketingNotificationEmails))) {
            unset($this->MarketingNotificationEmails);
        } else {
            $this->MarketingNotificationEmails = $marketingNotificationEmails;
        }
        return $this;
    }
    /**
     * Get MultipleDataLocationsForServicesEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMultipleDataLocationsForServicesEnabled()
    {
        return isset($this->MultipleDataLocationsForServicesEnabled) ? $this->MultipleDataLocationsForServicesEnabled : null;
    }
    /**
     * Set MultipleDataLocationsForServicesEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $multipleDataLocationsForServicesEnabled
     * @return \StructType\CompanyInformation
     */
    public function setMultipleDataLocationsForServicesEnabled($multipleDataLocationsForServicesEnabled = null)
    {
        if (is_null($multipleDataLocationsForServicesEnabled) || (is_array($multipleDataLocationsForServicesEnabled) && empty($multipleDataLocationsForServicesEnabled))) {
            unset($this->MultipleDataLocationsForServicesEnabled);
        } else {
            $this->MultipleDataLocationsForServicesEnabled = $multipleDataLocationsForServicesEnabled;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\CompanyInformation
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get PasswordSynchronizationEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPasswordSynchronizationEnabled()
    {
        return isset($this->PasswordSynchronizationEnabled) ? $this->PasswordSynchronizationEnabled : null;
    }
    /**
     * Set PasswordSynchronizationEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $passwordSynchronizationEnabled
     * @return \StructType\CompanyInformation
     */
    public function setPasswordSynchronizationEnabled($passwordSynchronizationEnabled = null)
    {
        if (is_null($passwordSynchronizationEnabled) || (is_array($passwordSynchronizationEnabled) && empty($passwordSynchronizationEnabled))) {
            unset($this->PasswordSynchronizationEnabled);
        } else {
            $this->PasswordSynchronizationEnabled = $passwordSynchronizationEnabled;
        }
        return $this;
    }
    /**
     * Get PortalSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PortalSettings|null
     */
    public function getPortalSettings()
    {
        return isset($this->PortalSettings) ? $this->PortalSettings : null;
    }
    /**
     * Set PortalSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PortalSettings $portalSettings
     * @return \StructType\CompanyInformation
     */
    public function setPortalSettings(\StructType\PortalSettings $portalSettings = null)
    {
        if (is_null($portalSettings) || (is_array($portalSettings) && empty($portalSettings))) {
            unset($this->PortalSettings);
        } else {
            $this->PortalSettings = $portalSettings;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \StructType\CompanyInformation
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get PreferredLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredLanguage()
    {
        return isset($this->PreferredLanguage) ? $this->PreferredLanguage : null;
    }
    /**
     * Set PreferredLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredLanguage
     * @return \StructType\CompanyInformation
     */
    public function setPreferredLanguage($preferredLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($preferredLanguage) && !is_string($preferredLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredLanguage)), __LINE__);
        }
        if (is_null($preferredLanguage) || (is_array($preferredLanguage) && empty($preferredLanguage))) {
            unset($this->PreferredLanguage);
        } else {
            $this->PreferredLanguage = $preferredLanguage;
        }
        return $this;
    }
    /**
     * Get ReleaseTrack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReleaseTrack()
    {
        return isset($this->ReleaseTrack) ? $this->ReleaseTrack : null;
    }
    /**
     * Set ReleaseTrack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\O365TenantReleaseTrack::valueIsValid()
     * @uses \EnumType\O365TenantReleaseTrack::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseTrack
     * @return \StructType\CompanyInformation
     */
    public function setReleaseTrack($releaseTrack = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\O365TenantReleaseTrack::valueIsValid($releaseTrack)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $releaseTrack, implode(', ', \EnumType\O365TenantReleaseTrack::getValidValues())), __LINE__);
        }
        if (is_null($releaseTrack) || (is_array($releaseTrack) && empty($releaseTrack))) {
            unset($this->ReleaseTrack);
        } else {
            $this->ReleaseTrack = $releaseTrack;
        }
        return $this;
    }
    /**
     * Get ReplicationScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplicationScope()
    {
        return isset($this->ReplicationScope) ? $this->ReplicationScope : null;
    }
    /**
     * Set ReplicationScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replicationScope
     * @return \StructType\CompanyInformation
     */
    public function setReplicationScope($replicationScope = null)
    {
        // validation for constraint: string
        if (!is_null($replicationScope) && !is_string($replicationScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replicationScope)), __LINE__);
        }
        if (is_null($replicationScope) || (is_array($replicationScope) && empty($replicationScope))) {
            unset($this->ReplicationScope);
        } else {
            $this->ReplicationScope = $replicationScope;
        }
        return $this;
    }
    /**
     * Get RmsViralSignUpEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRmsViralSignUpEnabled()
    {
        return isset($this->RmsViralSignUpEnabled) ? $this->RmsViralSignUpEnabled : null;
    }
    /**
     * Set RmsViralSignUpEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $rmsViralSignUpEnabled
     * @return \StructType\CompanyInformation
     */
    public function setRmsViralSignUpEnabled($rmsViralSignUpEnabled = null)
    {
        if (is_null($rmsViralSignUpEnabled) || (is_array($rmsViralSignUpEnabled) && empty($rmsViralSignUpEnabled))) {
            unset($this->RmsViralSignUpEnabled);
        } else {
            $this->RmsViralSignUpEnabled = $rmsViralSignUpEnabled;
        }
        return $this;
    }
    /**
     * Get SecurityComplianceNotificationEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getSecurityComplianceNotificationEmails()
    {
        return isset($this->SecurityComplianceNotificationEmails) ? $this->SecurityComplianceNotificationEmails : null;
    }
    /**
     * Set SecurityComplianceNotificationEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $securityComplianceNotificationEmails
     * @return \StructType\CompanyInformation
     */
    public function setSecurityComplianceNotificationEmails(\ArrayType\ArrayOfstring $securityComplianceNotificationEmails = null)
    {
        if (is_null($securityComplianceNotificationEmails) || (is_array($securityComplianceNotificationEmails) && empty($securityComplianceNotificationEmails))) {
            unset($this->SecurityComplianceNotificationEmails);
        } else {
            $this->SecurityComplianceNotificationEmails = $securityComplianceNotificationEmails;
        }
        return $this;
    }
    /**
     * Get SecurityComplianceNotificationPhones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getSecurityComplianceNotificationPhones()
    {
        return isset($this->SecurityComplianceNotificationPhones) ? $this->SecurityComplianceNotificationPhones : null;
    }
    /**
     * Set SecurityComplianceNotificationPhones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $securityComplianceNotificationPhones
     * @return \StructType\CompanyInformation
     */
    public function setSecurityComplianceNotificationPhones(\ArrayType\ArrayOfstring $securityComplianceNotificationPhones = null)
    {
        if (is_null($securityComplianceNotificationPhones) || (is_array($securityComplianceNotificationPhones) && empty($securityComplianceNotificationPhones))) {
            unset($this->SecurityComplianceNotificationPhones);
        } else {
            $this->SecurityComplianceNotificationPhones = $securityComplianceNotificationPhones;
        }
        return $this;
    }
    /**
     * Get SelfServePasswordResetEnabled value
     * @return bool|null
     */
    public function getSelfServePasswordResetEnabled()
    {
        return $this->SelfServePasswordResetEnabled;
    }
    /**
     * Set SelfServePasswordResetEnabled value
     * @param bool $selfServePasswordResetEnabled
     * @return \StructType\CompanyInformation
     */
    public function setSelfServePasswordResetEnabled($selfServePasswordResetEnabled = null)
    {
        $this->SelfServePasswordResetEnabled = $selfServePasswordResetEnabled;
        return $this;
    }
    /**
     * Get ServiceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServiceInformation|null
     */
    public function getServiceInformation()
    {
        return isset($this->ServiceInformation) ? $this->ServiceInformation : null;
    }
    /**
     * Set ServiceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServiceInformation $serviceInformation
     * @return \StructType\CompanyInformation
     */
    public function setServiceInformation(\ArrayType\ArrayOfServiceInformation $serviceInformation = null)
    {
        if (is_null($serviceInformation) || (is_array($serviceInformation) && empty($serviceInformation))) {
            unset($this->ServiceInformation);
        } else {
            $this->ServiceInformation = $serviceInformation;
        }
        return $this;
    }
    /**
     * Get ServiceInstanceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServiceInstanceInformation|null
     */
    public function getServiceInstanceInformation()
    {
        return isset($this->ServiceInstanceInformation) ? $this->ServiceInstanceInformation : null;
    }
    /**
     * Set ServiceInstanceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServiceInstanceInformation $serviceInstanceInformation
     * @return \StructType\CompanyInformation
     */
    public function setServiceInstanceInformation(\ArrayType\ArrayOfServiceInstanceInformation $serviceInstanceInformation = null)
    {
        if (is_null($serviceInstanceInformation) || (is_array($serviceInstanceInformation) && empty($serviceInstanceInformation))) {
            unset($this->ServiceInstanceInformation);
        } else {
            $this->ServiceInstanceInformation = $serviceInstanceInformation;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\CompanyInformation
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \StructType\CompanyInformation
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Get SubscriptionProvisioningLimited value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSubscriptionProvisioningLimited()
    {
        return isset($this->SubscriptionProvisioningLimited) ? $this->SubscriptionProvisioningLimited : null;
    }
    /**
     * Set SubscriptionProvisioningLimited value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $subscriptionProvisioningLimited
     * @return \StructType\CompanyInformation
     */
    public function setSubscriptionProvisioningLimited($subscriptionProvisioningLimited = null)
    {
        if (is_null($subscriptionProvisioningLimited) || (is_array($subscriptionProvisioningLimited) && empty($subscriptionProvisioningLimited))) {
            unset($this->SubscriptionProvisioningLimited);
        } else {
            $this->SubscriptionProvisioningLimited = $subscriptionProvisioningLimited;
        }
        return $this;
    }
    /**
     * Get TechnicalNotificationEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getTechnicalNotificationEmails()
    {
        return isset($this->TechnicalNotificationEmails) ? $this->TechnicalNotificationEmails : null;
    }
    /**
     * Set TechnicalNotificationEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $technicalNotificationEmails
     * @return \StructType\CompanyInformation
     */
    public function setTechnicalNotificationEmails(\ArrayType\ArrayOfstring $technicalNotificationEmails = null)
    {
        if (is_null($technicalNotificationEmails) || (is_array($technicalNotificationEmails) && empty($technicalNotificationEmails))) {
            unset($this->TechnicalNotificationEmails);
        } else {
            $this->TechnicalNotificationEmails = $technicalNotificationEmails;
        }
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return isset($this->TelephoneNumber) ? $this->TelephoneNumber : null;
    }
    /**
     * Set TelephoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephoneNumber
     * @return \StructType\CompanyInformation
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        if (is_null($telephoneNumber) || (is_array($telephoneNumber) && empty($telephoneNumber))) {
            unset($this->TelephoneNumber);
        } else {
            $this->TelephoneNumber = $telephoneNumber;
        }
        return $this;
    }
    /**
     * Get UIExtensibilityUris value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getUIExtensibilityUris()
    {
        return isset($this->UIExtensibilityUris) ? $this->UIExtensibilityUris : null;
    }
    /**
     * Set UIExtensibilityUris value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValueOfstringstring $uIExtensibilityUris
     * @return \StructType\CompanyInformation
     */
    public function setUIExtensibilityUris(\ArrayType\ArrayOfKeyValueOfstringstring $uIExtensibilityUris = null)
    {
        if (is_null($uIExtensibilityUris) || (is_array($uIExtensibilityUris) && empty($uIExtensibilityUris))) {
            unset($this->UIExtensibilityUris);
        } else {
            $this->UIExtensibilityUris = $uIExtensibilityUris;
        }
        return $this;
    }
    /**
     * Get UsersPermissionToCreateGroupsEnabled value
     * @return bool|null
     */
    public function getUsersPermissionToCreateGroupsEnabled()
    {
        return $this->UsersPermissionToCreateGroupsEnabled;
    }
    /**
     * Set UsersPermissionToCreateGroupsEnabled value
     * @param bool $usersPermissionToCreateGroupsEnabled
     * @return \StructType\CompanyInformation
     */
    public function setUsersPermissionToCreateGroupsEnabled($usersPermissionToCreateGroupsEnabled = null)
    {
        $this->UsersPermissionToCreateGroupsEnabled = $usersPermissionToCreateGroupsEnabled;
        return $this;
    }
    /**
     * Get UsersPermissionToCreateLOBAppsEnabled value
     * @return bool|null
     */
    public function getUsersPermissionToCreateLOBAppsEnabled()
    {
        return $this->UsersPermissionToCreateLOBAppsEnabled;
    }
    /**
     * Set UsersPermissionToCreateLOBAppsEnabled value
     * @param bool $usersPermissionToCreateLOBAppsEnabled
     * @return \StructType\CompanyInformation
     */
    public function setUsersPermissionToCreateLOBAppsEnabled($usersPermissionToCreateLOBAppsEnabled = null)
    {
        $this->UsersPermissionToCreateLOBAppsEnabled = $usersPermissionToCreateLOBAppsEnabled;
        return $this;
    }
    /**
     * Get UsersPermissionToReadOtherUsersEnabled value
     * @return bool|null
     */
    public function getUsersPermissionToReadOtherUsersEnabled()
    {
        return $this->UsersPermissionToReadOtherUsersEnabled;
    }
    /**
     * Set UsersPermissionToReadOtherUsersEnabled value
     * @param bool $usersPermissionToReadOtherUsersEnabled
     * @return \StructType\CompanyInformation
     */
    public function setUsersPermissionToReadOtherUsersEnabled($usersPermissionToReadOtherUsersEnabled = null)
    {
        $this->UsersPermissionToReadOtherUsersEnabled = $usersPermissionToReadOtherUsersEnabled;
        return $this;
    }
    /**
     * Get UsersPermissionToUserConsentToAppEnabled value
     * @return bool|null
     */
    public function getUsersPermissionToUserConsentToAppEnabled()
    {
        return $this->UsersPermissionToUserConsentToAppEnabled;
    }
    /**
     * Set UsersPermissionToUserConsentToAppEnabled value
     * @param bool $usersPermissionToUserConsentToAppEnabled
     * @return \StructType\CompanyInformation
     */
    public function setUsersPermissionToUserConsentToAppEnabled($usersPermissionToUserConsentToAppEnabled = null)
    {
        $this->UsersPermissionToUserConsentToAppEnabled = $usersPermissionToUserConsentToAppEnabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
