<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdministrativeUnitSearchDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AdministrativeUnitSearchDefinition
 * @subpackage Structs
 */
class AdministrativeUnitSearchDefinition extends SearchDefinition
{
    /**
     * The IncludedProperties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $IncludedProperties;
    /**
     * The UserObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserObjectId;
    /**
     * The UserPrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPrincipalName;
    /**
     * Constructor method for AdministrativeUnitSearchDefinition
     * @uses AdministrativeUnitSearchDefinition::setIncludedProperties()
     * @uses AdministrativeUnitSearchDefinition::setUserObjectId()
     * @uses AdministrativeUnitSearchDefinition::setUserPrincipalName()
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @param string $userObjectId
     * @param string $userPrincipalName
     */
    public function __construct(\ArrayType\ArrayOfstring $includedProperties = null, $userObjectId = null, $userPrincipalName = null)
    {
        $this
            ->setIncludedProperties($includedProperties)
            ->setUserObjectId($userObjectId)
            ->setUserPrincipalName($userPrincipalName);
    }
    /**
     * Get IncludedProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getIncludedProperties()
    {
        return isset($this->IncludedProperties) ? $this->IncludedProperties : null;
    }
    /**
     * Set IncludedProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @return \StructType\AdministrativeUnitSearchDefinition
     */
    public function setIncludedProperties(\ArrayType\ArrayOfstring $includedProperties = null)
    {
        if (is_null($includedProperties) || (is_array($includedProperties) && empty($includedProperties))) {
            unset($this->IncludedProperties);
        } else {
            $this->IncludedProperties = $includedProperties;
        }
        return $this;
    }
    /**
     * Get UserObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserObjectId()
    {
        return isset($this->UserObjectId) ? $this->UserObjectId : null;
    }
    /**
     * Set UserObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userObjectId
     * @return \StructType\AdministrativeUnitSearchDefinition
     */
    public function setUserObjectId($userObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($userObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $userObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($userObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userObjectId) && !is_string($userObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userObjectId)), __LINE__);
        }
        if (is_null($userObjectId) || (is_array($userObjectId) && empty($userObjectId))) {
            unset($this->UserObjectId);
        } else {
            $this->UserObjectId = $userObjectId;
        }
        return $this;
    }
    /**
     * Get UserPrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPrincipalName()
    {
        return isset($this->UserPrincipalName) ? $this->UserPrincipalName : null;
    }
    /**
     * Set UserPrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPrincipalName
     * @return \StructType\AdministrativeUnitSearchDefinition
     */
    public function setUserPrincipalName($userPrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($userPrincipalName) && !is_string($userPrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPrincipalName)), __LINE__);
        }
        if (is_null($userPrincipalName) || (is_array($userPrincipalName) && empty($userPrincipalName))) {
            unset($this->UserPrincipalName);
        } else {
            $this->UserPrincipalName = $userPrincipalName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdministrativeUnitSearchDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
