<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddUserRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddUserRequest
 * @subpackage Structs
 */
class AddUserRequest extends Request
{
    /**
     * The ForceChangePassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ForceChangePassword;
    /**
     * The LicenseAssignment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountSkuIdentifier
     */
    public $LicenseAssignment;
    /**
     * The LicenseOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLicenseOption
     */
    public $LicenseOptions;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\User
     */
    public $User;
    /**
     * Constructor method for AddUserRequest
     * @uses AddUserRequest::setForceChangePassword()
     * @uses AddUserRequest::setLicenseAssignment()
     * @uses AddUserRequest::setLicenseOptions()
     * @uses AddUserRequest::setPassword()
     * @uses AddUserRequest::setUser()
     * @param bool $forceChangePassword
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $licenseAssignment
     * @param \ArrayType\ArrayOfLicenseOption $licenseOptions
     * @param string $password
     * @param \StructType\User $user
     */
    public function __construct($forceChangePassword = null, \ArrayType\ArrayOfAccountSkuIdentifier $licenseAssignment = null, \ArrayType\ArrayOfLicenseOption $licenseOptions = null, $password = null, \StructType\User $user = null)
    {
        $this
            ->setForceChangePassword($forceChangePassword)
            ->setLicenseAssignment($licenseAssignment)
            ->setLicenseOptions($licenseOptions)
            ->setPassword($password)
            ->setUser($user);
    }
    /**
     * Get ForceChangePassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceChangePassword()
    {
        return isset($this->ForceChangePassword) ? $this->ForceChangePassword : null;
    }
    /**
     * Set ForceChangePassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceChangePassword
     * @return \StructType\AddUserRequest
     */
    public function setForceChangePassword($forceChangePassword = null)
    {
        if (is_null($forceChangePassword) || (is_array($forceChangePassword) && empty($forceChangePassword))) {
            unset($this->ForceChangePassword);
        } else {
            $this->ForceChangePassword = $forceChangePassword;
        }
        return $this;
    }
    /**
     * Get LicenseAssignment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountSkuIdentifier|null
     */
    public function getLicenseAssignment()
    {
        return isset($this->LicenseAssignment) ? $this->LicenseAssignment : null;
    }
    /**
     * Set LicenseAssignment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $licenseAssignment
     * @return \StructType\AddUserRequest
     */
    public function setLicenseAssignment(\ArrayType\ArrayOfAccountSkuIdentifier $licenseAssignment = null)
    {
        if (is_null($licenseAssignment) || (is_array($licenseAssignment) && empty($licenseAssignment))) {
            unset($this->LicenseAssignment);
        } else {
            $this->LicenseAssignment = $licenseAssignment;
        }
        return $this;
    }
    /**
     * Get LicenseOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLicenseOption|null
     */
    public function getLicenseOptions()
    {
        return isset($this->LicenseOptions) ? $this->LicenseOptions : null;
    }
    /**
     * Set LicenseOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLicenseOption $licenseOptions
     * @return \StructType\AddUserRequest
     */
    public function setLicenseOptions(\ArrayType\ArrayOfLicenseOption $licenseOptions = null)
    {
        if (is_null($licenseOptions) || (is_array($licenseOptions) && empty($licenseOptions))) {
            unset($this->LicenseOptions);
        } else {
            $this->LicenseOptions = $licenseOptions;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\AddUserRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\User $user
     * @return \StructType\AddUserRequest
     */
    public function setUser(\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddUserRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
