<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddServicePrincipalRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddServicePrincipalRequest
 * @subpackage Structs
 */
class AddServicePrincipalRequest extends Request
{
    /**
     * The AccountEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AccountEnabled;
    /**
     * The Addresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRedirectUri
     */
    public $Addresses;
    /**
     * The AppPrincipalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppPrincipalId;
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServicePrincipalCredential
     */
    public $Credentials;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The ServicePrincipalNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ServicePrincipalNames;
    /**
     * The TrustedForDelegation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TrustedForDelegation;
    /**
     * Constructor method for AddServicePrincipalRequest
     * @uses AddServicePrincipalRequest::setAccountEnabled()
     * @uses AddServicePrincipalRequest::setAddresses()
     * @uses AddServicePrincipalRequest::setAppPrincipalId()
     * @uses AddServicePrincipalRequest::setCredentials()
     * @uses AddServicePrincipalRequest::setDisplayName()
     * @uses AddServicePrincipalRequest::setServicePrincipalNames()
     * @uses AddServicePrincipalRequest::setTrustedForDelegation()
     * @param bool $accountEnabled
     * @param \ArrayType\ArrayOfRedirectUri $addresses
     * @param string $appPrincipalId
     * @param \ArrayType\ArrayOfServicePrincipalCredential $credentials
     * @param string $displayName
     * @param \ArrayType\ArrayOfstring $servicePrincipalNames
     * @param bool $trustedForDelegation
     */
    public function __construct($accountEnabled = null, \ArrayType\ArrayOfRedirectUri $addresses = null, $appPrincipalId = null, \ArrayType\ArrayOfServicePrincipalCredential $credentials = null, $displayName = null, \ArrayType\ArrayOfstring $servicePrincipalNames = null, $trustedForDelegation = null)
    {
        $this
            ->setAccountEnabled($accountEnabled)
            ->setAddresses($addresses)
            ->setAppPrincipalId($appPrincipalId)
            ->setCredentials($credentials)
            ->setDisplayName($displayName)
            ->setServicePrincipalNames($servicePrincipalNames)
            ->setTrustedForDelegation($trustedForDelegation);
    }
    /**
     * Get AccountEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAccountEnabled()
    {
        return isset($this->AccountEnabled) ? $this->AccountEnabled : null;
    }
    /**
     * Set AccountEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $accountEnabled
     * @return \StructType\AddServicePrincipalRequest
     */
    public function setAccountEnabled($accountEnabled = null)
    {
        if (is_null($accountEnabled) || (is_array($accountEnabled) && empty($accountEnabled))) {
            unset($this->AccountEnabled);
        } else {
            $this->AccountEnabled = $accountEnabled;
        }
        return $this;
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRedirectUri|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRedirectUri $addresses
     * @return \StructType\AddServicePrincipalRequest
     */
    public function setAddresses(\ArrayType\ArrayOfRedirectUri $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get AppPrincipalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppPrincipalId()
    {
        return isset($this->AppPrincipalId) ? $this->AppPrincipalId : null;
    }
    /**
     * Set AppPrincipalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appPrincipalId
     * @return \StructType\AddServicePrincipalRequest
     */
    public function setAppPrincipalId($appPrincipalId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($appPrincipalId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $appPrincipalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($appPrincipalId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($appPrincipalId) && !is_string($appPrincipalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appPrincipalId)), __LINE__);
        }
        if (is_null($appPrincipalId) || (is_array($appPrincipalId) && empty($appPrincipalId))) {
            unset($this->AppPrincipalId);
        } else {
            $this->AppPrincipalId = $appPrincipalId;
        }
        return $this;
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServicePrincipalCredential|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServicePrincipalCredential $credentials
     * @return \StructType\AddServicePrincipalRequest
     */
    public function setCredentials(\ArrayType\ArrayOfServicePrincipalCredential $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\AddServicePrincipalRequest
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get ServicePrincipalNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getServicePrincipalNames()
    {
        return isset($this->ServicePrincipalNames) ? $this->ServicePrincipalNames : null;
    }
    /**
     * Set ServicePrincipalNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $servicePrincipalNames
     * @return \StructType\AddServicePrincipalRequest
     */
    public function setServicePrincipalNames(\ArrayType\ArrayOfstring $servicePrincipalNames = null)
    {
        if (is_null($servicePrincipalNames) || (is_array($servicePrincipalNames) && empty($servicePrincipalNames))) {
            unset($this->ServicePrincipalNames);
        } else {
            $this->ServicePrincipalNames = $servicePrincipalNames;
        }
        return $this;
    }
    /**
     * Get TrustedForDelegation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTrustedForDelegation()
    {
        return isset($this->TrustedForDelegation) ? $this->TrustedForDelegation : null;
    }
    /**
     * Set TrustedForDelegation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $trustedForDelegation
     * @return \StructType\AddServicePrincipalRequest
     */
    public function setTrustedForDelegation($trustedForDelegation = null)
    {
        if (is_null($trustedForDelegation) || (is_array($trustedForDelegation) && empty($trustedForDelegation))) {
            unset($this->TrustedForDelegation);
        } else {
            $this->TrustedForDelegation = $trustedForDelegation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddServicePrincipalRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
