<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddServicePrincipalCredentialsRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddServicePrincipalCredentialsRequest
 * @subpackage Structs
 */
class AddServicePrincipalCredentialsRequest extends Request
{
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServicePrincipalCredential
     */
    public $Credentials;
    /**
     * The MsodsAsKeyStore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MsodsAsKeyStore;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * Constructor method for AddServicePrincipalCredentialsRequest
     * @uses AddServicePrincipalCredentialsRequest::setCredentials()
     * @uses AddServicePrincipalCredentialsRequest::setMsodsAsKeyStore()
     * @uses AddServicePrincipalCredentialsRequest::setObjectId()
     * @param \ArrayType\ArrayOfServicePrincipalCredential $credentials
     * @param bool $msodsAsKeyStore
     * @param string $objectId
     */
    public function __construct(\ArrayType\ArrayOfServicePrincipalCredential $credentials = null, $msodsAsKeyStore = null, $objectId = null)
    {
        $this
            ->setCredentials($credentials)
            ->setMsodsAsKeyStore($msodsAsKeyStore)
            ->setObjectId($objectId);
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServicePrincipalCredential|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServicePrincipalCredential $credentials
     * @return \StructType\AddServicePrincipalCredentialsRequest
     */
    public function setCredentials(\ArrayType\ArrayOfServicePrincipalCredential $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get MsodsAsKeyStore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMsodsAsKeyStore()
    {
        return isset($this->MsodsAsKeyStore) ? $this->MsodsAsKeyStore : null;
    }
    /**
     * Set MsodsAsKeyStore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $msodsAsKeyStore
     * @return \StructType\AddServicePrincipalCredentialsRequest
     */
    public function setMsodsAsKeyStore($msodsAsKeyStore = null)
    {
        if (is_null($msodsAsKeyStore) || (is_array($msodsAsKeyStore) && empty($msodsAsKeyStore))) {
            unset($this->MsodsAsKeyStore);
        } else {
            $this->MsodsAsKeyStore = $msodsAsKeyStore;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \StructType\AddServicePrincipalCredentialsRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddServicePrincipalCredentialsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
