<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddServicePrincipalCredentialsBySpnRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddServicePrincipalCredentialsBySpnRequest
 * @subpackage Structs
 */
class AddServicePrincipalCredentialsBySpnRequest extends Request
{
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServicePrincipalCredential
     */
    public $Credentials;
    /**
     * The MsodsAsKeyStore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MsodsAsKeyStore;
    /**
     * The ServicePrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServicePrincipalName;
    /**
     * Constructor method for AddServicePrincipalCredentialsBySpnRequest
     * @uses AddServicePrincipalCredentialsBySpnRequest::setCredentials()
     * @uses AddServicePrincipalCredentialsBySpnRequest::setMsodsAsKeyStore()
     * @uses AddServicePrincipalCredentialsBySpnRequest::setServicePrincipalName()
     * @param \ArrayType\ArrayOfServicePrincipalCredential $credentials
     * @param bool $msodsAsKeyStore
     * @param string $servicePrincipalName
     */
    public function __construct(\ArrayType\ArrayOfServicePrincipalCredential $credentials = null, $msodsAsKeyStore = null, $servicePrincipalName = null)
    {
        $this
            ->setCredentials($credentials)
            ->setMsodsAsKeyStore($msodsAsKeyStore)
            ->setServicePrincipalName($servicePrincipalName);
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServicePrincipalCredential|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServicePrincipalCredential $credentials
     * @return \StructType\AddServicePrincipalCredentialsBySpnRequest
     */
    public function setCredentials(\ArrayType\ArrayOfServicePrincipalCredential $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get MsodsAsKeyStore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMsodsAsKeyStore()
    {
        return isset($this->MsodsAsKeyStore) ? $this->MsodsAsKeyStore : null;
    }
    /**
     * Set MsodsAsKeyStore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $msodsAsKeyStore
     * @return \StructType\AddServicePrincipalCredentialsBySpnRequest
     */
    public function setMsodsAsKeyStore($msodsAsKeyStore = null)
    {
        if (is_null($msodsAsKeyStore) || (is_array($msodsAsKeyStore) && empty($msodsAsKeyStore))) {
            unset($this->MsodsAsKeyStore);
        } else {
            $this->MsodsAsKeyStore = $msodsAsKeyStore;
        }
        return $this;
    }
    /**
     * Get ServicePrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServicePrincipalName()
    {
        return isset($this->ServicePrincipalName) ? $this->ServicePrincipalName : null;
    }
    /**
     * Set ServicePrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $servicePrincipalName
     * @return \StructType\AddServicePrincipalCredentialsBySpnRequest
     */
    public function setServicePrincipalName($servicePrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($servicePrincipalName) && !is_string($servicePrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePrincipalName)), __LINE__);
        }
        if (is_null($servicePrincipalName) || (is_array($servicePrincipalName) && empty($servicePrincipalName))) {
            unset($this->ServicePrincipalName);
        } else {
            $this->ServicePrincipalName = $servicePrincipalName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddServicePrincipalCredentialsBySpnRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
