<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDomainRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddDomainRequest
 * @subpackage Structs
 */
class AddDomainRequest extends Request
{
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Domain
     */
    public $Domain;
    /**
     * The ForceTakeover
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ForceTakeover;
    /**
     * Constructor method for AddDomainRequest
     * @uses AddDomainRequest::setDomain()
     * @uses AddDomainRequest::setForceTakeover()
     * @param \StructType\Domain $domain
     * @param string $forceTakeover
     */
    public function __construct(\StructType\Domain $domain = null, $forceTakeover = null)
    {
        $this
            ->setDomain($domain)
            ->setForceTakeover($forceTakeover);
    }
    /**
     * Get Domain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Domain|null
     */
    public function getDomain()
    {
        return isset($this->Domain) ? $this->Domain : null;
    }
    /**
     * Set Domain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Domain $domain
     * @return \StructType\AddDomainRequest
     */
    public function setDomain(\StructType\Domain $domain = null)
    {
        if (is_null($domain) || (is_array($domain) && empty($domain))) {
            unset($this->Domain);
        } else {
            $this->Domain = $domain;
        }
        return $this;
    }
    /**
     * Get ForceTakeover value
     * @return string|null
     */
    public function getForceTakeover()
    {
        return $this->ForceTakeover;
    }
    /**
     * Set ForceTakeover value
     * @uses \EnumType\ForceTakeoverOption::valueIsValid()
     * @uses \EnumType\ForceTakeoverOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $forceTakeover
     * @return \StructType\AddDomainRequest
     */
    public function setForceTakeover($forceTakeover = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ForceTakeoverOption::valueIsValid($forceTakeover)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $forceTakeover, implode(', ', \EnumType\ForceTakeoverOption::getValidValues())), __LINE__);
        }
        $this->ForceTakeover = $forceTakeover;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddDomainRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
