<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdministrativeUnitMembersRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddAdministrativeUnitMembersRequest
 * @subpackage Structs
 */
class AddAdministrativeUnitMembersRequest extends Request
{
    /**
     * The AdministrativeUnitMembers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdministrativeUnitMember
     */
    public $AdministrativeUnitMembers;
    /**
     * The AdministrativeUnitObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdministrativeUnitObjectId;
    /**
     * Constructor method for AddAdministrativeUnitMembersRequest
     * @uses AddAdministrativeUnitMembersRequest::setAdministrativeUnitMembers()
     * @uses AddAdministrativeUnitMembersRequest::setAdministrativeUnitObjectId()
     * @param \ArrayType\ArrayOfAdministrativeUnitMember $administrativeUnitMembers
     * @param string $administrativeUnitObjectId
     */
    public function __construct(\ArrayType\ArrayOfAdministrativeUnitMember $administrativeUnitMembers = null, $administrativeUnitObjectId = null)
    {
        $this
            ->setAdministrativeUnitMembers($administrativeUnitMembers)
            ->setAdministrativeUnitObjectId($administrativeUnitObjectId);
    }
    /**
     * Get AdministrativeUnitMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdministrativeUnitMember|null
     */
    public function getAdministrativeUnitMembers()
    {
        return isset($this->AdministrativeUnitMembers) ? $this->AdministrativeUnitMembers : null;
    }
    /**
     * Set AdministrativeUnitMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdministrativeUnitMember $administrativeUnitMembers
     * @return \StructType\AddAdministrativeUnitMembersRequest
     */
    public function setAdministrativeUnitMembers(\ArrayType\ArrayOfAdministrativeUnitMember $administrativeUnitMembers = null)
    {
        if (is_null($administrativeUnitMembers) || (is_array($administrativeUnitMembers) && empty($administrativeUnitMembers))) {
            unset($this->AdministrativeUnitMembers);
        } else {
            $this->AdministrativeUnitMembers = $administrativeUnitMembers;
        }
        return $this;
    }
    /**
     * Get AdministrativeUnitObjectId value
     * @return string|null
     */
    public function getAdministrativeUnitObjectId()
    {
        return $this->AdministrativeUnitObjectId;
    }
    /**
     * Set AdministrativeUnitObjectId value
     * @param string $administrativeUnitObjectId
     * @return \StructType\AddAdministrativeUnitMembersRequest
     */
    public function setAdministrativeUnitObjectId($administrativeUnitObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($administrativeUnitObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($administrativeUnitObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($administrativeUnitObjectId) && !is_string($administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($administrativeUnitObjectId)), __LINE__);
        }
        $this->AdministrativeUnitObjectId = $administrativeUnitObjectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddAdministrativeUnitMembersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
