<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListAdministrativeUnits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAdministrativeUnits $parameters
     * @return \StructType\ListAdministrativeUnitsResponse|bool
     */
    public function ListAdministrativeUnits(\StructType\ListAdministrativeUnits $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAdministrativeUnits($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAdministrativeUnitMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAdministrativeUnitMembers $parameters
     * @return \StructType\ListAdministrativeUnitMembersResponse|bool
     */
    public function ListAdministrativeUnitMembers(\StructType\ListAdministrativeUnitMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAdministrativeUnitMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListSubscriptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSubscriptions $parameters
     * @return \StructType\ListSubscriptionsResponse|bool
     */
    public function ListSubscriptions(\StructType\ListSubscriptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListSubscriptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListAccountSkus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAccountSkus $parameters
     * @return \StructType\ListAccountSkusResponse|bool
     */
    public function ListAccountSkus(\StructType\ListAccountSkus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListAccountSkus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListPartnerContracts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPartnerContracts $parameters
     * @return \StructType\ListPartnerContractsResponse|bool
     */
    public function ListPartnerContracts(\StructType\ListPartnerContracts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListPartnerContracts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListDirSyncProvisioningErrors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDirSyncProvisioningErrors $parameters
     * @return \StructType\ListDirSyncProvisioningErrorsResponse|bool
     */
    public function ListDirSyncProvisioningErrors(\StructType\ListDirSyncProvisioningErrors $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListDirSyncProvisioningErrors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListContacts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListContacts $parameters
     * @return \StructType\ListContactsResponse|bool
     */
    public function ListContacts(\StructType\ListContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListDomains
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDomains $parameters
     * @return \StructType\ListDomainsResponse|bool
     */
    public function ListDomains(\StructType\ListDomains $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListDomains($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListGroups $parameters
     * @return \StructType\ListGroupsResponse|bool
     */
    public function ListGroups(\StructType\ListGroups $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListGroupMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListGroupMembers $parameters
     * @return \StructType\ListGroupMembersResponse|bool
     */
    public function ListGroupMembers(\StructType\ListGroupMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListGroupMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListRoles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRoles $parameters
     * @return \StructType\ListRolesResponse|bool
     */
    public function ListRoles(\StructType\ListRoles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListRoles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListRolesForUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRolesForUser $parameters
     * @return \StructType\ListRolesForUserResponse|bool
     */
    public function ListRolesForUser(\StructType\ListRolesForUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListRolesForUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListRolesForUserByUpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRolesForUserByUpn $parameters
     * @return \StructType\ListRolesForUserByUpnResponse|bool
     */
    public function ListRolesForUserByUpn(\StructType\ListRolesForUserByUpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListRolesForUserByUpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListRoleMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRoleMembers $parameters
     * @return \StructType\ListRoleMembersResponse|bool
     */
    public function ListRoleMembers(\StructType\ListRoleMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListRoleMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListRoleScopedMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRoleScopedMembers $parameters
     * @return \StructType\ListRoleScopedMembersResponse|bool
     */
    public function ListRoleScopedMembers(\StructType\ListRoleScopedMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListRoleScopedMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUsers $parameters
     * @return \StructType\ListUsersResponse|bool
     */
    public function ListUsers(\StructType\ListUsers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListUsers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListUsersByStrongAuthentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUsersByStrongAuthentication $parameters
     * @return \StructType\ListUsersByStrongAuthenticationResponse|bool
     */
    public function ListUsersByStrongAuthentication(\StructType\ListUsersByStrongAuthentication $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListUsersByStrongAuthentication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListServicePrincipals
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListServicePrincipals $parameters
     * @return \StructType\ListServicePrincipalsResponse|bool
     */
    public function ListServicePrincipals(\StructType\ListServicePrincipals $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListServicePrincipals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListServicePrincipalCredentials
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListServicePrincipalCredentials $parameters
     * @return \StructType\ListServicePrincipalCredentialsResponse|bool
     */
    public function ListServicePrincipalCredentials(\StructType\ListServicePrincipalCredentials $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListServicePrincipalCredentials($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListServicePrincipalCredentialsByAppPrincipalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListServicePrincipalCredentialsByAppPrincipalId $parameters
     * @return \StructType\ListServicePrincipalCredentialsByAppPrincipalIdResponse|bool
     */
    public function ListServicePrincipalCredentialsByAppPrincipalId(\StructType\ListServicePrincipalCredentialsByAppPrincipalId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListServicePrincipalCredentialsByAppPrincipalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListServicePrincipalCredentialsBySpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListServicePrincipalCredentialsBySpn $parameters
     * @return \StructType\ListServicePrincipalCredentialsBySpnResponse|bool
     */
    public function ListServicePrincipalCredentialsBySpn(\StructType\ListServicePrincipalCredentialsBySpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListServicePrincipalCredentialsBySpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListAccountSkusResponse|\StructType\ListAdministrativeUnitMembersResponse|\StructType\ListAdministrativeUnitsResponse|\StructType\ListContactsResponse|\StructType\ListDirSyncProvisioningErrorsResponse|\StructType\ListDomainsResponse|\StructType\ListGroupMembersResponse|\StructType\ListGroupsResponse|\StructType\ListPartnerContractsResponse|\StructType\ListRoleMembersResponse|\StructType\ListRoleScopedMembersResponse|\StructType\ListRolesForUserByUpnResponse|\StructType\ListRolesForUserResponse|\StructType\ListRolesResponse|\StructType\ListServicePrincipalCredentialsByAppPrincipalIdResponse|\StructType\ListServicePrincipalCredentialsBySpnResponse|\StructType\ListServicePrincipalCredentialsResponse|\StructType\ListServicePrincipalsResponse|\StructType\ListSubscriptionsResponse|\StructType\ListUsersByStrongAuthenticationResponse|\StructType\ListUsersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
