<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Verify ServiceType
 * @subpackage Services
 */
class Verify extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VerifyDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VerifyDomain $parameters
     * @return \StructType\VerifyDomainResponse|bool
     */
    public function VerifyDomain(\StructType\VerifyDomain $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VerifyDomain($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VerifyDomain2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VerifyDomain2 $parameters
     * @return \StructType\VerifyDomain2Response|bool
     */
    public function VerifyDomain2(\StructType\VerifyDomain2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VerifyDomain2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VerifyEmailVerifiedDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VerifyEmailVerifiedDomain $parameters
     * @return \StructType\VerifyEmailVerifiedDomainResponse|bool
     */
    public function VerifyEmailVerifiedDomain(\StructType\VerifyEmailVerifiedDomain $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VerifyEmailVerifiedDomain($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VerifyDomain2Response|\StructType\VerifyDomainResponse|\StructType\VerifyEmailVerifiedDomainResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
